/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.XWikiRecycleBinStoreInterface;
import com.xpn.xwiki.util.Programming;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public class DeletedDocument
extends Api {
    private static final String ADMIN_RIGHT = "admin";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedDocument.class);
    private final XWikiDeletedDocument deletedDoc;
    private UserReferenceResolver<DocumentReference> userReferenceResolver;

    public DeletedDocument(XWikiDeletedDocument deletedDoc, XWikiContext context) {
        super(context);
        this.deletedDoc = deletedDoc;
    }

    public String getFullName() {
        return this.deletedDoc.getFullName();
    }

    @Deprecated
    public String getLanguage() {
        return this.deletedDoc.getLanguage();
    }

    public Locale getLocale() {
        return this.deletedDoc.getLocale();
    }

    public Date getDate() {
        return this.deletedDoc.getDate();
    }

    public String getDeleter() {
        return this.deletedDoc.getDeleter();
    }

    public DocumentReference getDeleterReference() {
        return this.deletedDoc.getDeleterReference();
    }

    public long getId() {
        return this.deletedDoc.getId();
    }

    public String getBatchId() {
        return this.deletedDoc.getBatchId();
    }

    private UserReferenceResolver<DocumentReference> getUserReferenceResolver() {
        if (this.userReferenceResolver == null) {
            this.userReferenceResolver = (UserReferenceResolver)Utils.getComponent((Type)new DefaultParameterizedType(null, UserReferenceResolver.class, new Type[]{DocumentReference.class}), "document");
        }
        return this.userReferenceResolver;
    }

    private boolean hasAccess(Right right) {
        UserReference userReference = this.getUserReferenceResolver().resolve((Object)this.context.getUserReference(), new Object[0]);
        XWikiRecycleBinStoreInterface recycleBinStore = this.context.getWiki().getRecycleBinStore();
        return recycleBinStore.hasAccess(right, userReference, this.deletedDoc);
    }

    public boolean canUndelete() {
        return this.hasAccess(Right.EDIT);
    }

    public boolean canView() {
        return this.hasAccess(Right.VIEW);
    }

    public boolean canDelete() {
        try {
            XWikiDocument doc = new XWikiDocument();
            doc.setFullName(this.getFullName(), this.context);
            if (!this.hasAccessLevel("delete", this.getFullName())) {
                return false;
            }
            String waitdays = this.hasAccessLevel(ADMIN_RIGHT, this.getFullName()) ? this.getXWikiContext().getWiki().Param("xwiki.store.recyclebin.adminWaitDays", "0") : this.getXWikiContext().getWiki().Param("xwiki.store.recyclebin.waitDays", "7");
            int seconds = (int)(Double.parseDouble(waitdays) * 24.0 * 60.0 * 60.0 + 0.5);
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getDate());
            cal.add(13, seconds);
            return cal.before(Calendar.getInstance());
        }
        catch (Exception ex) {
            LOGGER.warn("Exception while checking if entry [{}] can be removed from the recycle bin", (Object)this.getId(), (Object)ex);
            return false;
        }
    }

    @Programming
    public XWikiDeletedDocument getDeletedDocument() {
        if (this.hasProgrammingRights()) {
            return this.deletedDoc;
        }
        return null;
    }

    public Document getDocument() {
        if (this.canUndelete()) {
            try {
                return new Document(this.deletedDoc.restoreDocument(null, this.context), this.context);
            }
            catch (XWikiException e) {
                LOGGER.warn("Failed to parse deleted document [{}]", (Object)this.getFullName(), (Object)e);
            }
        }
        return null;
    }

    public DocumentReference getDocumentReference() {
        return this.deletedDoc.getDocumentReference();
    }
}

