/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.Programming;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedAttachment
extends Api {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedAttachment.class);
    private final com.xpn.xwiki.doc.DeletedAttachment deletedAttachment;

    public DeletedAttachment(com.xpn.xwiki.doc.DeletedAttachment deletedAttachment, XWikiContext context) {
        super(context);
        this.deletedAttachment = deletedAttachment;
    }

    public long getId() {
        return this.deletedAttachment.getId();
    }

    public String getFilename() {
        return this.deletedAttachment.getFilename();
    }

    public String getDocName() {
        return this.deletedAttachment.getDocName();
    }

    public String getDeleter() {
        return this.deletedAttachment.getDeleter();
    }

    public Date getDate() {
        return this.deletedAttachment.getDate();
    }

    public Attachment getAttachment() {
        try {
            XWikiAttachment attachment = this.deletedAttachment.restoreAttachment();
            if (attachment != null) {
                Document doc = this.context.getWiki().getDocument(this.getDocName(), this.context).newDocument(this.context);
                return new Attachment(doc, attachment, this.context);
            }
        }
        catch (XWikiException ex) {
            LOGGER.warn("Failed to parse deleted attachment", (Throwable)ex);
        }
        return null;
    }

    @Programming
    public com.xpn.xwiki.doc.DeletedAttachment getDeletedAttachment() {
        if (this.hasProgrammingRights()) {
            return this.deletedAttachment;
        }
        return null;
    }

    public boolean canRestore() {
        return false;
    }

    public boolean canDelete() {
        try {
            XWikiDocument doc = new XWikiDocument();
            doc.setFullName(this.getDocName(), this.context);
            if (!this.hasAdminRights() && !this.getXWikiContext().getWiki().getRightService().checkAccess("delete", doc, this.context)) {
                return false;
            }
            String waitdays = this.hasAdminRights() ? this.getXWikiContext().getWiki().Param("xwiki.store.recyclebin.adminWaitDays", "0") : this.getXWikiContext().getWiki().Param("xwiki.store.recyclebin.waitDays", "7");
            int seconds = (int)(Double.parseDouble(waitdays) * 24.0 * 60.0 * 60.0 + 0.5);
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getDate());
            cal.add(13, seconds);
            return cal.before(Calendar.getInstance());
        }
        catch (Exception ex) {
            LOGGER.warn("Exception while checking if entry [" + this.getId() + "] can be removed from the recycle bin", (Throwable)ex);
            return false;
        }
    }

    public void delete() throws XWikiException {
        if (this.canDelete()) {
            try {
                this.context.getWiki().getAttachmentRecycleBinStore().deleteFromRecycleBin(this.getId(), this.context, true);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to purge deleted attachment", (Throwable)ex);
            }
        } else {
            Object[] args = new Object[]{this.getFilename(), this.getDocName()};
            throw new XWikiException(9, 9001, "Cannot permanently delete attachment {0}@{1} from the trash", null, args);
        }
    }
}

