/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.model.reference.AttachmentReference;

public class Attachment
extends Api {
    private static final Logger LOGGER = LoggerFactory.getLogger(Attachment.class);
    private Document doc;
    private XWikiAttachment attachment;

    public Attachment(Document doc, XWikiAttachment attachment, XWikiContext context) {
        super(context);
        this.doc = doc;
        this.attachment = attachment;
    }

    public Document getDocument() {
        return this.doc;
    }

    public long getId() {
        return this.attachment.getId();
    }

    public long getDocId() {
        return this.doc.getId();
    }

    @Deprecated
    public int getFilesize() {
        long longSize = this.getLongSize();
        return longSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)longSize;
    }

    public long getLongSize() {
        return this.attachment.getLongSize();
    }

    public String getFilename() {
        return this.attachment.getFilename();
    }

    public String getAuthor() {
        return this.attachment.getAuthor();
    }

    public String getVersion() {
        return this.attachment.getVersion();
    }

    public Version getRCSVersion() {
        return this.attachment.getRCSVersion();
    }

    public String getComment() {
        return this.attachment.getComment();
    }

    public Date getDate() {
        return this.attachment.getDate();
    }

    public byte[] getContent() throws XWikiException {
        return this.getContentAsBytes();
    }

    public byte[] getContentAsBytes() throws XWikiException {
        try {
            InputStream contentInputStream = this.attachment.getContentInputStream(this.getXWikiContext());
            if (contentInputStream != null) {
                return IOUtils.toByteArray((InputStream)contentInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    public InputStream getContentInputStream() {
        try {
            return this.attachment.getContentInputStream(this.getXWikiContext());
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to get attachment input stream", (Throwable)e);
            return null;
        }
    }

    public String getContentAsString() throws XWikiException {
        return new String(this.getContentAsBytes());
    }

    public String getContentAsString(String charset) throws XWikiException {
        byte[] contentBytes = this.getContentAsBytes();
        try {
            return new String(contentBytes, charset);
        }
        catch (UnsupportedEncodingException ex) {
            return new String(contentBytes);
        }
    }

    public Version[] getVersions() throws XWikiException {
        this.attachment.loadArchive(this.getXWikiContext());
        return this.attachment.getVersions();
    }

    public List<Version> getVersionList() throws XWikiException {
        return this.attachment.getVersionList();
    }

    public XWikiAttachment getAttachment() {
        if (this.hasProgrammingRights()) {
            return this.attachment;
        }
        return null;
    }

    public String getMimeType() {
        return this.attachment.getMimeType(this.getXWikiContext());
    }

    public boolean isImage() {
        return this.attachment.isImage(this.getXWikiContext());
    }

    public Attachment getAttachmentRevision(String rev) throws XWikiException {
        XWikiAttachment att = this.attachment.getAttachmentRevision(rev, this.getXWikiContext());
        return att == null ? null : new Attachment(this.getDocument(), att, this.context);
    }

    public AttachmentReference getReference() {
        return this.attachment.getReference();
    }
}

