/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.api;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.ApiCompatibilityAspect;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class Api {
    protected XWikiContext context;
    private Provider<XWikiContext> xcontextProvider;
    private AuthorizationManager authorizationManager;
    private ContextualAuthorizationManager contextualAuthorizationManager;
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;

    public Api(XWikiContext context) {
        this.context = context;
    }

    protected XWikiContext getXWikiContext() {
        if (this.xcontextProvider == null) {
            this.xcontextProvider = (Provider)Utils.getComponent(XWikiContext.TYPE_PROVIDER);
        }
        this.context = (XWikiContext)this.xcontextProvider.get();
        return this.context;
    }

    protected AuthorizationManager getAuthorizationManager() {
        if (this.authorizationManager == null) {
            this.authorizationManager = Utils.getComponent(AuthorizationManager.class);
        }
        return this.authorizationManager;
    }

    protected ContextualAuthorizationManager getContextualAuthorizationManager() {
        if (this.contextualAuthorizationManager == null) {
            this.contextualAuthorizationManager = Utils.getComponent(ContextualAuthorizationManager.class);
        }
        return this.contextualAuthorizationManager;
    }

    private EntityReferenceSerializer<String> getDefaultEntityReferenceSerializer() {
        if (this.defaultEntityReferenceSerializer == null) {
            this.defaultEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
        }
        return this.defaultEntityReferenceSerializer;
    }

    public boolean hasProgrammingRights() {
        XWiki xwiki = this.context.getWiki();
        return xwiki.getRightService().hasProgrammingRights(this.context);
    }

    public boolean hasAdminRights() {
        XWiki xwiki = this.context.getWiki();
        return xwiki.getRightService().hasAdminRights(this.context);
    }

    public boolean hasWikiAdminRights() {
        XWiki xwiki = this.context.getWiki();
        return xwiki.getRightService().hasWikiAdminRights(this.context);
    }

    public boolean hasAccessLevel(String right, String docname) throws XWikiException {
        XWiki xwiki = this.context.getWiki();
        return xwiki.getRightService().hasAccessLevel(right, this.context.getUser(), docname, this.context);
    }

    protected boolean hasAccess(Right right, DocumentReference entityReference) {
        return this.getAuthorizationManager().hasAccess(right, this.context.getUserReference(), (EntityReference)entityReference);
    }

    protected List<Document> convert(List<XWikiDocument> xdocList) {
        ArrayList<Document> docList = new ArrayList<Document>();
        for (XWikiDocument xdoc : xdocList) {
            docList.add(xdoc.newDocument(this.context));
        }
        return docList;
    }

    protected Document convert(XWikiDocument xdoc) {
        return xdoc == null ? null : xdoc.newDocument(this.context);
    }

    @Deprecated
    String getEffectiveScriptAuthorName() {
        DocumentReference authorReference = this.getXWikiContext().getAuthorReference();
        return authorReference != null ? (String)this.getDefaultEntityReferenceSerializer().serialize((EntityReference)authorReference, new Object[0]) : "XWikiGuest";
    }

    DocumentReference getEffectiveAuthorReference() {
        if (!this.getXWikiContext().hasDroppedPermissions()) {
            return this.getXWikiContext().getAuthorReference();
        }
        return null;
    }

    protected Attachment convert(XWikiAttachment xattach) {
        return xattach == null ? null : new Attachment(this.convert(xattach.getDoc()), xattach, this.context);
    }

    protected List<Attachment> convertAttachments(List<XWikiAttachment> xattaches) {
        ArrayList<Attachment> outList = new ArrayList<Attachment>(xattaches.size());
        for (XWikiAttachment xattach : xattaches) {
            outList.add(this.convert(xattach));
        }
        return outList;
    }

    @Deprecated
    public boolean checkProgrammingRights() {
        return ApiCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_api_ApiCompatibilityAspect$com_xpn_xwiki_api_Api$checkProgrammingRights(this);
    }
}

