/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContextCompatibilityAspect;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.validation.XWikiValidationStatus;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiMessageTool;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.stability.Unstable;

public class XWikiContext
extends Hashtable<Object, Object> {
    public static final ParameterizedType TYPE_PROVIDER = new DefaultParameterizedType(null, Provider.class, new Type[]{XWikiContext.class});
    public static final int MODE_SERVLET = 0;
    public static final int MODE_PORTLET = 1;
    public static final int MODE_XMLRPC = 2;
    public static final int MODE_ATOM = 3;
    public static final int MODE_PDF = 4;
    public static final int MODE_GWT = 5;
    public static final int MODE_GWT_DEBUG = 6;
    public static final String EXECUTIONCONTEXT_KEY = "xwikicontext";
    @Deprecated
    public static final String KEY_LEGACY_VELOCITYCONTEXT = "vcontext";
    public static final String INACTIVE_USER_REFERENCE = "inactiveUserReference";
    protected static final Logger LOGGER = LoggerFactory.getLogger(XWikiContext.class);
    private static final String WIKI_KEY = "wiki";
    private static final String ORIGINAL_WIKI_KEY = "originalWiki";
    private static final String USER_KEY = "user";
    private static final String USERREFERENCE_KEY = "userreference";
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer;
    private Execution execution;
    private boolean finished = false;
    private boolean responseSent = false;
    private XWiki wiki;
    private XWikiEngineContext engine_context;
    private XWikiRequest request;
    private XWikiResponse response;
    private XWikiForm form;
    private String action;
    private String orig_wikiId;
    private WikiReference wikiReference;
    private DocumentReference userReference;
    private Locale locale;
    private static final String LANGUAGE_KEY = "language";
    private Locale interfaceLocale;
    private int mode;
    private URL url;
    private XWikiURLFactory URLFactory;
    private int cacheDuration = 0;
    private int classCacheSize = 20;
    private Map<DocumentReference, BaseClass> classCache = Collections.synchronizedMap(new LRUMap(this.classCacheSize));
    private List<String> displayedFields = Collections.synchronizedList(new ArrayList());

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    private EntityReferenceSerializer<String> getLocalEntityReferenceSerializer() {
        if (this.localEntityReferenceSerializer == null) {
            this.localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        }
        return this.localEntityReferenceSerializer;
    }

    private EntityReferenceSerializer<String> getCompactWikiEntityReferenceSerializer() {
        if (this.compactWikiEntityReferenceSerializer == null) {
            this.compactWikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
        }
        return this.compactWikiEntityReferenceSerializer;
    }

    private Execution getExecution() {
        if (this.execution == null) {
            this.execution = Utils.getComponent(Execution.class);
        }
        return this.execution;
    }

    private ExecutionContext getExecutionContext() {
        if (this.getExecution() != null) {
            return this.getExecution().getContext();
        }
        return null;
    }

    public XWiki getWiki() {
        return this.wiki;
    }

    public Util getUtil() {
        Util util = (Util)this.get("util");
        if (util == null) {
            util = new Util();
            this.put("util", util);
        }
        return util;
    }

    public void setWiki(XWiki wiki) {
        this.wiki = wiki;
    }

    public XWikiEngineContext getEngineContext() {
        return this.engine_context;
    }

    public void setEngineContext(XWikiEngineContext engine_context) {
        this.engine_context = engine_context;
    }

    @Deprecated(since="17.0.0RC1")
    public XWikiRequest getRequest() {
        return this.request;
    }

    @Deprecated(since="17.0.0RC1")
    public void setRequest(XWikiRequest request) {
        this.request = request;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Deprecated(since="17.0.0RC1")
    public XWikiResponse getResponse() {
        return this.response;
    }

    @Deprecated(since="17.0.0RC1")
    public void setResponse(XWikiResponse response) {
        this.response = response;
    }

    @Deprecated
    public String getDatabase() {
        return this.getWikiId();
    }

    public String getWikiId() {
        return this.wikiReference != null ? this.wikiReference.getName() : null;
    }

    public WikiReference getWikiReference() {
        return this.wikiReference;
    }

    @Deprecated
    public void setDatabase(String wikiId) {
        this.setWikiId(wikiId);
    }

    public void setWikiId(String wikiId) {
        this.setWikiReference(wikiId != null ? new WikiReference(wikiId) : null);
    }

    public void setWikiReference(WikiReference wikiReference) {
        this.wikiReference = wikiReference;
        if (this.wikiReference == null) {
            super.remove(WIKI_KEY);
        } else {
            super.put(WIKI_KEY, this.wikiReference.getName());
            if (this.orig_wikiId == null) {
                this.orig_wikiId = this.wikiReference.getName();
                super.put(ORIGINAL_WIKI_KEY, this.wikiReference.getName());
            }
        }
    }

    @Override
    public synchronized Object get(Object key) {
        ExecutionContext executionContext;
        Object value = WIKI_KEY.equals(key) ? this.getWikiId() : (KEY_LEGACY_VELOCITYCONTEXT.equals(key) ? ((executionContext = this.getExecutionContext()) != null ? executionContext.getProperty("velocityContext") : null) : super.get(key));
        return value;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object previous;
        if (WIKI_KEY.equals(key)) {
            previous = this.get(WIKI_KEY);
            this.setWikiId((String)value);
        } else if (KEY_LEGACY_VELOCITYCONTEXT.equals(key)) {
            ExecutionContext executionContext = this.getExecutionContext();
            if (executionContext != null) {
                previous = executionContext.getProperty("velocityContext");
                executionContext.setProperty("velocityContext", value);
            } else {
                previous = null;
            }
        } else {
            previous = value != null ? super.put(key, value) : super.remove(key);
        }
        return previous;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object previous;
        if (WIKI_KEY.equals(key)) {
            previous = this.get(WIKI_KEY);
            this.setWikiId(null);
        } else if (KEY_LEGACY_VELOCITYCONTEXT.equals(key)) {
            ExecutionContext executionContext = this.getExecutionContext();
            if (executionContext != null) {
                previous = executionContext.getProperty("velocityContext");
                executionContext.removeProperty("velocityContext");
            } else {
                previous = null;
            }
        } else {
            previous = super.remove(key);
        }
        return previous;
    }

    @Deprecated
    public String getOriginalDatabase() {
        return this.getOriginalWikiId();
    }

    public String getOriginalWikiId() {
        return this.orig_wikiId;
    }

    @Deprecated
    public void setOriginalDatabase(String wikiId) {
        this.setOriginalWikiId(wikiId);
    }

    public void setOriginalWikiId(String wikiId) {
        this.orig_wikiId = wikiId;
        if (wikiId == null) {
            this.remove(ORIGINAL_WIKI_KEY);
        } else {
            this.put(ORIGINAL_WIKI_KEY, wikiId);
        }
    }

    public boolean isMainWiki() {
        return this.isMainWiki(this.getWikiId());
    }

    public boolean isMainWiki(String wikiName) {
        return StringUtils.equalsIgnoreCase((CharSequence)wikiName, (CharSequence)this.getMainXWiki());
    }

    public XWikiDocument getDoc() {
        return (XWikiDocument)this.get("doc");
    }

    public void setDoc(XWikiDocument doc) {
        if (doc == null) {
            this.remove("doc");
        } else {
            this.put("doc", doc);
        }
    }

    public DocumentReference getUserReference() {
        return this.userReference;
    }

    public void setUserReference(DocumentReference userReference) {
        if (userReference == null) {
            this.userReference = null;
            this.remove(USER_KEY);
            this.remove(USERREFERENCE_KEY);
        } else {
            this.userReference = userReference;
            boolean ismain = this.isMainWiki(this.userReference.getWikiReference().getName());
            this.put(USER_KEY, new XWikiUser(this.getUser(), ismain));
            this.put(USERREFERENCE_KEY, this.userReference);
            if (this.userReference.getName().equals("XWikiGuest")) {
                LOGGER.warn("A reference to XWikiGuest user has been set instead of null. This is probably a mistake.", (Throwable)new Exception("See stack trace"));
            }
        }
    }

    private void setUserInternal(String user, boolean main) {
        if (user == null) {
            this.setUserReference(null);
        } else if (user.endsWith("XWiki.XWikiGuest") || user.equals("XWikiGuest")) {
            this.setUserReference(null);
            this.put(USER_KEY, new XWikiUser(user, main));
        } else {
            this.setUserReference(this.resolveUserReference(user));
        }
    }

    private DocumentReference resolveUserReference(String user) {
        return this.getCurrentMixedDocumentReferenceResolver().resolve((Object)user, new Object[]{new SpaceReference("XWiki", new WikiReference(this.getWikiId() == null ? "xwiki" : this.getWikiId()))});
    }

    @Deprecated
    public void setUser(String user) {
        this.setUserInternal(user, false);
    }

    @Deprecated
    public String getUser() {
        if (this.userReference != null) {
            if (this.getWikiId() == null) {
                return (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)this.userReference, new Object[0]);
            }
            return (String)this.getCompactWikiEntityReferenceSerializer().serialize((EntityReference)this.userReference, new Object[]{new WikiReference(this.getWikiId())});
        }
        return "XWiki.XWikiGuest";
    }

    @Deprecated
    public String getLocalUser() {
        if (this.userReference != null) {
            return (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)this.userReference, new Object[0]);
        }
        return "XWiki.XWikiGuest";
    }

    @Deprecated
    public XWikiUser getXWikiUser() {
        if (this.userReference != null) {
            boolean ismain = this.isMainWiki(this.userReference.getWikiReference().getName());
            return new XWikiUser(this.getUser(), ismain);
        }
        return (XWikiUser)this.get(USER_KEY);
    }

    @Deprecated
    public String getLanguage() {
        return this.locale != null ? this.locale.toString() : null;
    }

    @Deprecated
    public void setLanguage(String language) {
        this.setLocale(LocaleUtils.toLocale((String)Util.normalizeLanguage(language)));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (locale == null) {
            this.remove(LANGUAGE_KEY);
        } else {
            this.put(LANGUAGE_KEY, locale.toString());
        }
    }

    @Deprecated
    public String getInterfaceLanguage() {
        return this.interfaceLocale != null ? this.interfaceLocale.toString() : null;
    }

    public Locale getInterfaceLocale() {
        return this.interfaceLocale;
    }

    public void setInterfaceLocale(Locale interfaceLocale) {
        this.interfaceLocale = interfaceLocale;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public XWikiURLFactory getURLFactory() {
        return this.URLFactory;
    }

    public void setURLFactory(XWikiURLFactory URLFactory) {
        this.URLFactory = URLFactory;
    }

    public XWikiForm getForm() {
        return this.form;
    }

    public void setForm(XWikiForm form) {
        this.form = form;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isResponseSent() {
        return this.responseSent;
    }

    public void setResponseSent(boolean responseSent) {
        this.responseSent = responseSent;
    }

    public XWikiDocument getWikiServer() {
        String currentWiki = this.getWikiId();
        try {
            this.setWikiId(this.getMainXWiki());
            XWikiDocument xWikiDocument = this.getWiki().getDocument(XWiki.getServerWikiPage(currentWiki), this);
            return xWikiDocument;
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to get wiki descriptor for wiki [{}]", (Object)currentWiki, (Object)e);
        }
        finally {
            this.setWikiId(currentWiki);
        }
        return null;
    }

    public int getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(int cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public String getMainXWiki() {
        return (String)this.get("mainxwiki");
    }

    public void setMainXWiki(String str) {
        this.put("mainxwiki", str);
    }

    public void addBaseClass(BaseClass bclass) {
        this.classCache.put(bclass.getDocumentReference(), bclass);
    }

    public BaseClass getBaseClass(DocumentReference classReference) {
        return this.classCache.get(classReference);
    }

    public void removeBaseClass(DocumentReference classReference) {
        this.classCache.remove(classReference);
    }

    public void flushClassCache() {
        this.classCache.clear();
    }

    public void setLinksAction(String action) {
        this.put("links_action", action);
    }

    public void unsetLinksAction() {
        this.remove("links_action");
    }

    public String getLinksAction() {
        return (String)this.get("links_action");
    }

    public void setLinksQueryString(String value) {
        this.put("links_qs", value);
    }

    public void unsetLinksQueryString() {
        this.remove("links_qs");
    }

    public String getLinksQueryString() {
        return (String)this.get("links_qs");
    }

    @Deprecated
    public XWikiMessageTool getMessageTool() {
        XWikiMessageTool msg = (XWikiMessageTool)this.get("msg");
        if (msg == null) {
            this.getWiki().prepareResources(this);
            msg = (XWikiMessageTool)this.get("msg");
        }
        return msg;
    }

    public XWikiValidationStatus getValidationStatus() {
        return (XWikiValidationStatus)this.get("validation_status");
    }

    public void setValidationStatus(XWikiValidationStatus status) {
        this.put("validation_status", status);
    }

    public void addDisplayedField(String fieldname) {
        this.displayedFields.add(fieldname);
    }

    public List<String> getDisplayedFields() {
        return this.displayedFields;
    }

    @Deprecated
    public String getEditorWysiwyg() {
        return (String)this.get("editor_wysiwyg");
    }

    public void dropPermissions() {
        this.put("hasDroppedPermissions", Boolean.TRUE);
    }

    public boolean hasDroppedPermissions() {
        if (this.get("hasDroppedPermissions") != null) {
            return true;
        }
        Object dropped = this.getExecution().getContext().getProperty("hasDroppedPermissions");
        if (!(dropped instanceof Integer)) {
            return false;
        }
        return (Integer)dropped == System.identityHashCode(this.getExecution().getContext());
    }

    @Override
    public synchronized XWikiContext clone() {
        XWikiContext context = (XWikiContext)super.clone();
        context.displayedFields = Collections.synchronizedList(new ArrayList<String>(this.displayedFields));
        context.classCache = Collections.synchronizedMap(new LRUMap(this.classCacheSize));
        return context;
    }

    public void declareInExecutionContext(ExecutionContext executionContext) {
        if (!executionContext.hasProperty(EXECUTIONCONTEXT_KEY)) {
            executionContext.newProperty(EXECUTIONCONTEXT_KEY).initial((Object)this).inherited().declare();
        } else {
            executionContext.setProperty(EXECUTIONCONTEXT_KEY, (Object)this);
        }
    }

    public DocumentReference getAuthorReference() {
        XWikiDocument sdoc = this.getSecureDocument();
        return sdoc != null ? sdoc.getContentAuthorReference() : this.getUserReference();
    }

    @Unstable
    public XWikiDocument getSecureDocument() {
        XWikiDocument sdoc = (XWikiDocument)this.get("sdoc");
        if (sdoc == null) {
            sdoc = this.getDoc();
        }
        return sdoc;
    }

    public static /* synthetic */ DocumentReferenceResolver ajc$get$currentMixedDocumentReferenceResolver(XWikiContext xWikiContext) {
        return xWikiContext.currentMixedDocumentReferenceResolver;
    }

    public static /* synthetic */ void ajc$set$currentMixedDocumentReferenceResolver(XWikiContext xWikiContext, DocumentReferenceResolver documentReferenceResolver) {
        xWikiContext.currentMixedDocumentReferenceResolver = documentReferenceResolver;
    }

    public /* synthetic */ void ajc$privMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setUserInternal(String string, boolean bl) {
        this.setUserInternal(string, bl);
    }

    public static /* synthetic */ Map ajc$get$classCache(XWikiContext xWikiContext) {
        return xWikiContext.classCache;
    }

    public static /* synthetic */ void ajc$set$classCache(XWikiContext xWikiContext, Map map) {
        xWikiContext.classCache = map;
    }

    @Deprecated
    public void addDocumentArchive(String string, XWikiDocumentArchive xWikiDocumentArchive) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$addDocumentArchive(this, string, xWikiDocumentArchive);
    }

    @Deprecated
    public void flushArchiveCache() {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$flushArchiveCache(this);
    }

    @Deprecated
    public BaseClass getBaseClass(String string) {
        return XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$getBaseClass(this, string);
    }

    @Deprecated
    public XWikiDocumentArchive getDocumentArchive(String string) {
        return XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$getDocumentArchive(this, string);
    }

    @Deprecated
    public String getWikiOwner() {
        return XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$getWikiOwner(this);
    }

    @Deprecated
    public boolean isVirtual() {
        return XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$isVirtual(this);
    }

    @Deprecated
    public void removeDocumentArchive(String string) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$removeDocumentArchive(this, string);
    }

    @Deprecated
    public void setInterfaceLanguage(String string) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setInterfaceLanguage(this, string);
    }

    @Deprecated
    public void setUser(String string, boolean bl) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setUser(this, string, bl);
    }

    @Deprecated
    public void setVirtual(boolean bl) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setVirtual(this, bl);
    }

    @Deprecated
    public void setWikiOwner(String string) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setWikiOwner(this, string);
    }

    @Deprecated
    public void setWikiServer(XWikiDocument xWikiDocument) {
        XWikiContextCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_XWikiContextCompatibilityAspect$com_xpn_xwiki_XWikiContext$setWikiServer(this, xWikiDocument);
    }
}

