/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.server;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.ApplicationStoppedEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;
import org.xwiki.officeimporter.server.OfficeServerException;

@Component
@Named(value="OfficeServerLifecycleListener")
@Singleton
public class OfficeServerLifecycleListener
implements EventListener {
    @Inject
    private OfficeServerConfiguration officeServerConfig;
    @Inject
    private OfficeServer officeServer;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return Arrays.asList(new ApplicationStartedEvent(), new ApplicationStoppedEvent());
    }

    public String getName() {
        return "OfficeServerLifecycleListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (ApplicationStartedEvent.class.getName().equals(event.getClass().getName())) {
            this.startOfficeServer();
        } else if (ApplicationStoppedEvent.class.getName().equals(event.getClass().getName())) {
            this.stopOfficeServer();
        }
    }

    private void startOfficeServer() {
        if (this.officeServerConfig.isAutoStart()) {
            try {
                this.officeServer.start();
            }
            catch (OfficeServerException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void stopOfficeServer() {
        try {
            this.officeServer.stop();
        }
        catch (OfficeServerException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

