/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.server;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;

@Component
@Singleton
public class DefaultOfficeServerConfiguration
implements OfficeServerConfiguration,
Initializable {
    private static final String PREFIX = "openoffice.";
    private static final int DEFAULT_SERVER_TYPE = 0;
    private static final int DEFAULT_SERVER_PORT = 8100;
    private static final boolean DEFAULT_AUTO_START = false;
    private static final int DEFAULT_MAX_TASKS_PER_PROCESS = 50;
    private static final long DEFAULT_TASK_EXECUTION_TIMEOUT = 60000L;
    private String defaultHomePath;
    @Inject
    private ConfigurationSource configuration;

    @Override
    public int getServerType() {
        return (Integer)this.configuration.getProperty("openoffice.serverType", (Object)0);
    }

    @Override
    public int getServerPort() {
        return (Integer)this.configuration.getProperty("openoffice.serverPort", (Object)8100);
    }

    @Override
    public int[] getServerPorts() {
        int[] result;
        List serverPorts = (List)this.configuration.getProperty("openoffice.serverPorts", List.class);
        if (serverPorts != null && serverPorts.size() > 0) {
            result = new int[serverPorts.size()];
            for (int i = 0; i < serverPorts.size(); ++i) {
                result[i] = Integer.parseInt((String)serverPorts.get(i));
            }
        } else {
            result = new int[]{this.getServerPort()};
        }
        return result;
    }

    @Override
    public boolean isAutoStart() {
        return (Boolean)this.configuration.getProperty("openoffice.autoStart", (Object)false);
    }

    @Override
    public String getHomePath() {
        String homePath = (String)this.configuration.getProperty("openoffice.homePath");
        if (homePath == null && (homePath = System.getenv("XWIKI_OFFICE_HOME")) == null) {
            homePath = this.defaultHomePath;
        }
        return homePath;
    }

    @Override
    public String getProfilePath() {
        return (String)this.configuration.getProperty("openoffice.profilePath");
    }

    @Override
    public int getMaxTasksPerProcess() {
        return (Integer)this.configuration.getProperty("openoffice.maxTasksPerProcess", (Object)50);
    }

    @Override
    public long getTaskExecutionTimeout() {
        return (Long)this.configuration.getProperty("openoffice.taskExecutionTimeout", (Object)60000L);
    }

    public void initialize() throws InitializationException {
        File defaultHomeFolder = LocalOfficeUtils.getDefaultOfficeHome();
        this.defaultHomePath = defaultHomeFolder != null ? defaultHomeFolder.getAbsolutePath() : null;
    }
}

