/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.server;

import java.io.File;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.text.LinkedImagesEmbedderFilter;
import org.jodconverter.local.office.ExternalOfficeManager;
import org.jodconverter.local.office.LocalOfficeManager;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.officeimporter.converter.OfficeConverter;
import org.xwiki.officeimporter.internal.converter.DefaultOfficeConverter;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.officeimporter.server.OfficeServerConfiguration;
import org.xwiki.officeimporter.server.OfficeServerException;

@Component
@Singleton
public class DefaultOfficeServer
implements OfficeServer {
    private static final String DOCUMENT_FORMATS_PATH = "/document-formats.js";
    @Inject
    private OfficeServerConfiguration config;
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;
    private OfficeManager jodManager;
    private LocalConverter jodConverter;
    private OfficeServer.ServerState state;
    private OfficeConverter converter;

    public DefaultOfficeServer() {
        this.setState(OfficeServer.ServerState.NOT_CONNECTED);
    }

    public void initialize() throws OfficeServerException {
        if (this.config.getServerType() == 0) {
            String profilePath;
            LocalOfficeManager.Builder configuration = LocalOfficeManager.builder();
            configuration.portNumbers(this.config.getServerPorts());
            String homePath = this.config.getHomePath();
            if (homePath != null) {
                configuration.officeHome(homePath);
            }
            if ((profilePath = this.config.getProfilePath()) != null) {
                configuration.templateProfileDir(new File(profilePath));
            }
            configuration.maxTasksPerProcess(Integer.valueOf(this.config.getMaxTasksPerProcess()));
            configuration.taskExecutionTimeout(Long.valueOf(this.config.getTaskExecutionTimeout()));
            try {
                this.jodManager = configuration.build();
            }
            catch (Exception e) {
                throw new OfficeServerException("Failed to start Office server. Reason: " + e.getMessage(), e);
            }
        } else if (this.config.getServerType() == 1) {
            ExternalOfficeManager.Builder externalProcessOfficeManager = ExternalOfficeManager.builder();
            externalProcessOfficeManager.portNumbers(this.config.getServerPorts());
            externalProcessOfficeManager.connectOnStart(Boolean.valueOf(true));
            this.jodManager = externalProcessOfficeManager.build();
        } else {
            this.setState(OfficeServer.ServerState.CONF_ERROR);
            throw new OfficeServerException("Invalid office server configuration.");
        }
        this.jodConverter = null;
        try (InputStream input = this.getClass().getResourceAsStream(DOCUMENT_FORMATS_PATH);){
            if (input != null) {
                this.jodConverter = ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().officeManager(this.jodManager)).formatRegistry((DocumentFormatRegistry)JsonDocumentFormatRegistry.create((InputStream)input))).filterChain(new Filter[]{new LinkedImagesEmbedderFilter()}).build();
            } else {
                this.logger.debug("{} is missing. The default document format registry will be used instead.", (Object)DOCUMENT_FORMATS_PATH);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse {} . The default document format registry will be used instead.", (Object)DOCUMENT_FORMATS_PATH, (Object)e);
        }
        if (this.jodConverter == null) {
            this.jodConverter = ((LocalConverter.Builder)LocalConverter.builder().officeManager(this.jodManager)).filterChain(new Filter[]{new LinkedImagesEmbedderFilter()}).build();
        }
        File workDir = this.environment.getTemporaryDirectory();
        this.converter = new DefaultOfficeConverter((DocumentConverter)this.jodConverter, workDir);
    }

    @Override
    public void refreshState() {
        if (this.jodManager == null) {
            this.setState(OfficeServer.ServerState.NOT_CONNECTED);
        } else if (this.jodManager.isRunning()) {
            this.setState(OfficeServer.ServerState.CONNECTED);
        } else {
            this.setState(OfficeServer.ServerState.NOT_CONNECTED);
        }
    }

    @Override
    public OfficeServer.ServerState getState() {
        return this.state;
    }

    @Override
    public void start() throws OfficeServerException {
        this.stop();
        this.initialize();
        try {
            this.jodManager.start();
            this.setState(OfficeServer.ServerState.CONNECTED);
            this.logger.info("Open Office instance started.");
        }
        catch (Exception e) {
            this.setState(OfficeServer.ServerState.ERROR);
            throw new OfficeServerException("Error while connecting / starting the office server.", e);
        }
    }

    @Override
    public void stop() throws OfficeServerException {
        block2: {
            boolean connected = this.checkState(OfficeServer.ServerState.CONNECTED);
            try {
                this.jodManager.stop();
                this.setState(OfficeServer.ServerState.NOT_CONNECTED);
                this.logger.info("Open Office instance stopped.");
            }
            catch (Exception e) {
                if (!connected) break block2;
                this.setState(OfficeServer.ServerState.ERROR);
                throw new OfficeServerException("Error while disconnecting / shutting down the office server.", e);
            }
        }
    }

    @Override
    public OfficeConverter getConverter() {
        return this.converter;
    }

    private void setState(OfficeServer.ServerState newState) {
        this.state = newState;
    }

    private boolean checkState(OfficeServer.ServerState expectedState) {
        return this.state == expectedState;
    }
}

