/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.html.filter.ElementSelector;

@Component
@Named(value="officeimporter/table")
@Singleton
public class TableFilter
extends AbstractHTMLFilter {
    public void filter(Document document, Map<String, String> cleaningParams) {
        List tableCells = this.filterDescendants(document.getDocumentElement(), new String[]{"td", "th"});
        for (Object cell : tableCells) {
            List paragraphs = this.filterChildren((Element)cell, "p");
            if (paragraphs.size() != 1) continue;
            this.replaceWithChildren((Element)paragraphs.get(0));
        }
        List emptyRows = this.filterDescendants(document.getDocumentElement(), new String[]{"tr"}, new ElementSelector(){

            public boolean isSelected(Element element) {
                return element.getChildNodes().getLength() == 0;
            }
        });
        for (Element emptyRow : emptyRows) {
            emptyRow.getParentNode().removeChild(emptyRow);
        }
        List rows = this.filterDescendants(document.getDocumentElement(), new String[]{"tr"});
        for (Element row : rows) {
            List childCells = this.filterDescendants(row, new String[]{"td"});
            if (!this.hasAttribute(childCells, "rowspan", true)) continue;
            for (Element childCell : childCells) {
                childCell.removeAttribute("rowspan");
            }
        }
    }
}

