/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="officeimporter/style")
@Singleton
public class StyleFilter
extends AbstractHTMLFilter {
    private static final String ATTRIBUTE_SEPARATOR = "|";
    private Map<String, String> attributeMappingsStrict = new HashMap<String, String>();

    public StyleFilter() {
        this.attributeMappingsStrict.put("a", "|href|name|");
        this.attributeMappingsStrict.put("img", "|alt|src|height|width|");
        this.attributeMappingsStrict.put("td", "|colspan|rowspan|");
        this.attributeMappingsStrict.put("th", "|colspan|");
    }

    public void filter(Document document, Map<String, String> cleaningParams) {
        String mode = cleaningParams.get("filterStyles");
        if (null != mode && mode.equals("strict")) {
            this.filter(document.getDocumentElement(), this.attributeMappingsStrict);
        }
    }

    private void filter(Node node, Map<String, String> attributeMappings) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String allowedAttributes = attributeMappings.get(element.getNodeName().toLowerCase());
            NamedNodeMap currentAttributes = element.getAttributes();
            if (null == allowedAttributes) {
                while (currentAttributes.getLength() > 0) {
                    currentAttributes.removeNamedItem(currentAttributes.item(0).getNodeName());
                }
            } else {
                ArrayList<String> attributesToBeRemoved = new ArrayList<String>();
                for (int i = 0; i < currentAttributes.getLength(); ++i) {
                    String attributeName = currentAttributes.item(i).getNodeName();
                    String pattern = ATTRIBUTE_SEPARATOR + attributeName.toLowerCase() + ATTRIBUTE_SEPARATOR;
                    if (allowedAttributes.indexOf(pattern) != -1) continue;
                    attributesToBeRemoved.add(attributeName);
                }
                for (String attribute : attributesToBeRemoved) {
                    currentAttributes.removeNamedItem(attribute);
                }
            }
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    this.filter(children.item(i), attributeMappings);
                }
            }
        }
    }
}

