/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="officeimporter/anchor")
@Singleton
public class AnchorFilter
extends AbstractHTMLFilter {
    public void filter(Document document, Map<String, String> cleaningParameters) {
        List links = this.filterDescendants(document.getDocumentElement(), new String[]{"a"});
        HashSet<String> fragmentIdentifiers = new HashSet<String>();
        ArrayList<Element> anchorsToRemove = new ArrayList<Element>();
        for (Element link : links) {
            if (!this.isAnchor(link)) continue;
            String fragmentIdentifier = link.getAttribute("name");
            if (fragmentIdentifiers.contains(fragmentIdentifier)) {
                anchorsToRemove.add(link);
            }
            fragmentIdentifiers.add(fragmentIdentifier);
        }
        for (Element anchor : anchorsToRemove) {
            this.replaceWithChildren(anchor);
        }
    }

    private boolean isAnchor(Node node) {
        return node instanceof Element && !"".equals(((Element)node).getAttribute("name"));
    }
}

