/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.converter;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.lang3.StringUtils;

public class OfficeConverterFileStorage {
    private static final Pattern SAFE_EXTENSION = Pattern.compile("^[a-zA-Z0-9]{1,20}$");
    private static final Pattern DISALLOWED_CHARACTERS = Pattern.compile("[/\\\\]");
    private static final String INPUT = "input";
    private File rootDir;
    private File inputDir;
    private File inputFile;
    private File outputDir;
    private File outputFile;

    public OfficeConverterFileStorage(File parentDir, String inputFileName, String outputFileName) throws IOException {
        boolean success = false;
        this.rootDir = new File(parentDir, UUID.randomUUID().toString());
        if (this.rootDir.mkdir()) {
            this.inputDir = new File(this.rootDir, INPUT);
            this.outputDir = new File(this.rootDir, "output");
            if (this.inputDir.mkdir() && this.outputDir.mkdir()) {
                this.inputFile = new File(this.inputDir, OfficeConverterFileStorage.cleanFilename(inputFileName));
                this.outputFile = new File(this.outputDir, OfficeConverterFileStorage.cleanFilename(outputFileName));
                success = true;
            }
        }
        if (!success) {
            this.cleanUp();
            throw new IOException("Could not create temporary directory hierarchy.");
        }
    }

    public static String getSafeInputFilenameFromExtension(String filename) {
        String extension = FileNameUtils.getExtension((String)filename);
        if (!SAFE_EXTENSION.matcher(extension).matches()) {
            extension = "";
        }
        return StringUtils.isBlank((CharSequence)extension) ? INPUT : "input." + extension;
    }

    public static String cleanFilename(String name) {
        String result = DISALLOWED_CHARACTERS.matcher(StringUtils.stripAccents((String)name)).replaceAll("_");
        if (StringUtils.isBlank((CharSequence)result)) {
            result = "fallback";
        }
        if (result.length() > 255) {
            result = result.substring(result.length() - 255);
        }
        return result;
    }

    public File getInputDir() {
        return this.inputDir;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean cleanUp() {
        if (this.rootDir.exists()) {
            return this.delete(this.rootDir);
        }
        return true;
    }

    private boolean delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        return file.delete();
    }
}

