/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal.cleaner;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;

@Component
@Named(value="wysiwyg")
@Singleton
public class WysiwygHTMLCleaner
implements HTMLCleaner {
    @Inject
    private HTMLCleaner defaultHtmlCleaner;
    @Inject
    @Named(value="officeimporter/stripper")
    private HTMLFilter stripperFilter;
    @Inject
    @Named(value="officeimporter/style")
    private HTMLFilter styleFilter;
    @Inject
    @Named(value="officeimporter/redundancy")
    private HTMLFilter redundancyFilter;
    @Inject
    @Named(value="officeimporter/paragraph")
    private HTMLFilter paragraphFilter;
    @Inject
    @Named(value="officeimporter/image")
    private HTMLFilter imageFilter;
    @Inject
    @Named(value="officeimporter/list")
    private HTMLFilter listFilter;
    @Inject
    @Named(value="officeimporter/table")
    private HTMLFilter tableFilter;

    public Document clean(Reader originalHtmlContent) {
        return this.clean(originalHtmlContent, this.getDefaultConfiguration());
    }

    public Document clean(Reader originalHtmlContent, HTMLCleanerConfiguration configuration) {
        return this.defaultHtmlCleaner.clean(originalHtmlContent, configuration);
    }

    public HTMLCleanerConfiguration getDefaultConfiguration() {
        HTMLCleanerConfiguration configuration = this.defaultHtmlCleaner.getDefaultConfiguration();
        ArrayList<HTMLFilter> filters = new ArrayList<HTMLFilter>(configuration.getFilters());
        filters.addAll(Arrays.asList(this.stripperFilter, this.styleFilter, this.redundancyFilter, this.paragraphFilter, this.imageFilter, this.listFilter, this.tableFilter));
        configuration.setFilters(filters);
        return configuration;
    }
}

