/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.officeimporter.internal;

import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.officeimporter.OfficeImporterException;
import org.xwiki.officeimporter.document.OfficeDocumentArtifact;
import org.xwiki.officeimporter.document.XDOMOfficeDocument;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component(roles={ModelBridge.class})
@Singleton
public class ModelBridge {
    @Inject
    private Logger logger;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private DocumentAccessBridge docBridge;

    public void save(XDOMOfficeDocument doc, DocumentReference documentReference, String syntaxId, DocumentReference parentReference, String title, boolean append) throws Exception {
        if (!this.contextualAuthorizationManager.hasAccess(Right.EDIT, (EntityReference)documentReference)) {
            String message = "You do not have edit rights on [%s] document.";
            throw new OfficeImporterException(String.format(message, documentReference));
        }
        if (this.docBridge.exists(documentReference) && append) {
            String currentSyntaxId = this.docBridge.getTranslatedDocumentInstance(documentReference).getSyntax().toIdString();
            if (!currentSyntaxId.equals(syntaxId)) {
                String message = "The target page [%s] exists but its syntax [%s] is different from the specified syntax [%s]";
                throw new OfficeImporterException(String.format(message, documentReference, currentSyntaxId, syntaxId));
            }
            String currentContent = this.docBridge.getDocumentContent(documentReference, null);
            String newContent = currentContent + "\n" + doc.getContentAsString(syntaxId);
            this.docBridge.setDocumentContent(documentReference, newContent, "Updated by office importer.", false);
        } else {
            String docTitle;
            this.docBridge.setDocumentSyntaxId(documentReference, syntaxId);
            this.docBridge.setDocumentContent(documentReference, doc.getContentAsString(syntaxId), "Created by office importer.", false);
            if (null != parentReference) {
                this.docBridge.setDocumentParentReference(documentReference, parentReference);
            }
            String string = docTitle = null == title ? doc.getTitle() : title;
            if (null != docTitle) {
                this.docBridge.setDocumentTitle(documentReference, docTitle);
            }
        }
        this.attachArtifacts(doc.getArtifactsMap(), documentReference);
    }

    private void attachArtifacts(Map<String, OfficeDocumentArtifact> artifactFiles, DocumentReference targetDocumentReference) {
        artifactFiles.forEach((filename, artifact) -> {
            AttachmentReference attachmentReference = new AttachmentReference(filename, targetDocumentReference);
            try (InputStream is = artifact.getContentInputStream();){
                this.docBridge.setAttachmentContent(attachmentReference, is);
            }
            catch (Exception ex) {
                this.logger.warn("Error while attaching artifact: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        });
    }
}

