/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.script;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.rendering.block.Block;
import org.xwiki.script.service.ScriptService;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Named(value="notification.filters")
@Singleton
public class NotificationFiltersScriptService
implements ScriptService {
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    @Named(value="cached")
    private FilterPreferencesModelBridge cachedFilterPreferencesModelBridge;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    @Deprecated
    private DocumentReference convertReference(UserReference userReference) throws NotificationException {
        DocumentReference result;
        if (userReference == null || userReference == CurrentUserReference.INSTANCE) {
            result = this.documentAccessBridge.getCurrentUserReference();
        } else if (userReference instanceof DocumentUserReference) {
            result = ((DocumentUserReference)userReference).getReference();
        } else {
            throw new NotificationException(String.format("This should only be used with DocumentUserReference, the given reference was a [%s]", userReference.getClass().getSimpleName()));
        }
        return result;
    }

    public Set<NotificationFilter> getToggleableNotificationFilters() throws NotificationException {
        return this.getToggleableNotificationFilters((UserReference)CurrentUserReference.INSTANCE);
    }

    public Set<NotificationFilter> getToggleableNotificationFilters(UserReference userReference) throws NotificationException {
        return this.notificationFilterManager.getToggleableFilters(this.notificationFilterManager.getAllFilters(this.convertReference(userReference), false)).collect(Collectors.toSet());
    }

    public Set<NotificationFilter> getWikiToggleableNotificationFilters(WikiReference wikiReference) throws NotificationException {
        return this.notificationFilterManager.getToggleableFilters(this.notificationFilterManager.getAllFilters(wikiReference)).collect(Collectors.toSet());
    }

    public Collection<NotificationFilter> getFilters() throws NotificationException {
        return this.getFilters((UserReference)CurrentUserReference.INSTANCE);
    }

    public Collection<NotificationFilter> getFilters(UserReference userReference) throws NotificationException {
        return this.notificationFilterManager.getAllFilters(this.convertReference(userReference), false);
    }

    public Collection<NotificationFilter> getWikiFilters(WikiReference wikiReference) throws NotificationException {
        return this.notificationFilterManager.getAllFilters(wikiReference);
    }

    public Set<NotificationFilterPreference> getFilterPreferences(NotificationFilter filter) throws NotificationException {
        return this.getFilterPreferences(filter, (UserReference)CurrentUserReference.INSTANCE);
    }

    public Set<NotificationFilterPreference> getFilterPreferences(NotificationFilter filter, UserReference userReference) throws NotificationException {
        return this.notificationFilterPreferenceManager.getFilterPreferences(this.notificationFilterPreferenceManager.getFilterPreferences(this.convertReference(userReference)), filter).collect(Collectors.toSet());
    }

    public Set<NotificationFilterPreference> getWikiFilterPreferences(NotificationFilter filter, WikiReference wikiReference) throws NotificationException {
        return this.notificationFilterPreferenceManager.getFilterPreferences(this.notificationFilterPreferenceManager.getFilterPreferences(wikiReference), filter).collect(Collectors.toSet());
    }

    public Block displayFilterPreference(NotificationFilter filter, NotificationFilterPreference preference) throws NotificationException {
        return this.notificationFilterManager.displayFilter(filter, preference);
    }

    public void deleteFilterPreference(String filterPreferenceId) throws NotificationException {
        this.deleteFilterPreference(filterPreferenceId, (UserReference)CurrentUserReference.INSTANCE);
    }

    public void deleteFilterPreference(String filterPreferenceId, UserReference userReference) throws NotificationException {
        this.notificationFilterPreferenceManager.deleteFilterPreference(this.convertReference(userReference), filterPreferenceId);
    }

    public void deleteWikiFilterPreference(String filterPreferenceId, WikiReference wikiReference) throws NotificationException {
        this.notificationFilterPreferenceManager.deleteFilterPreference(wikiReference, filterPreferenceId);
    }

    public void setFilterPreferenceEnabled(String filterPreferenceId, boolean enabled) throws NotificationException {
        this.setFilterPreferenceEnabled(filterPreferenceId, enabled, (UserReference)CurrentUserReference.INSTANCE);
    }

    public void setFilterPreferenceEnabled(String filterPreferenceId, boolean enabled, UserReference userReference) throws NotificationException {
        this.notificationFilterPreferenceManager.setFilterPreferenceEnabled(this.convertReference(userReference), filterPreferenceId, enabled);
    }

    public void setWikiFilterPreferenceEnabled(String filterPreferenceId, boolean enabled, WikiReference wikiReference) throws NotificationException {
        this.notificationFilterPreferenceManager.setFilterPreferenceEnabled(wikiReference, filterPreferenceId, enabled);
    }

    public void setStartDate(Date startDate) throws NotificationException {
        this.setStartDate(startDate, (UserReference)CurrentUserReference.INSTANCE);
    }

    public void setStartDate(Date startDate, UserReference userReference) throws NotificationException {
        this.notificationFilterPreferenceManager.setStartDateForUser(this.convertReference(userReference), startDate);
    }

    public void createScopeFilterPreference(NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        this.createScopeFilterPreference(type, formats, eventTypes, reference, (UserReference)CurrentUserReference.INSTANCE);
    }

    public void createScopeFilterPreference(NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference, UserReference userReference) throws NotificationException {
        this.cachedFilterPreferencesModelBridge.createScopeFilterPreference(this.convertReference(userReference), type, formats, eventTypes, reference);
    }

    public void createWikiScopeFilterPreference(NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference, WikiReference wikiReference) throws NotificationException {
        this.cachedFilterPreferencesModelBridge.createScopeFilterPreference(wikiReference, type, formats, eventTypes, reference);
    }
}

