/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;

@Component(roles={EventUserFilterPreferencesGetter.class})
@Singleton
public class EventUserFilterPreferencesGetter {
    @Inject
    private Logger logger;

    public boolean isUserExcluded(String testUser, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.getPreferences(filterPreferences, format, NotificationFilterType.EXCLUSIVE).anyMatch(pref -> Strings.CS.equals(pref.getUser(), testUser));
    }

    public boolean isUserFollowed(String testUser, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.getPreferences(filterPreferences, format, NotificationFilterType.INCLUSIVE).anyMatch(pref -> Strings.CS.equals(pref.getUser(), testUser));
    }

    public Collection<String> getFollowedUsers(Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.collect(this.getPreferences(filterPreferences, format, NotificationFilterType.INCLUSIVE));
    }

    public Stream<NotificationFilterPreference> getFollowedUsersPreferences(Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.getPreferences(filterPreferences, format, NotificationFilterType.INCLUSIVE);
    }

    public Collection<String> getExcludedUsers(Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.collect(this.getPreferences(filterPreferences, format, NotificationFilterType.EXCLUSIVE));
    }

    private Collection<String> collect(Stream<NotificationFilterPreference> stream) {
        return stream.map(fp -> fp.getUser()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    private Stream<NotificationFilterPreference> getPreferences(Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format, NotificationFilterType filterType) {
        try {
            return filterPreferences.stream().filter(pref -> this.matchFilter((NotificationFilterPreference)pref) && this.matchFormat((NotificationFilterPreference)pref, format) && this.matchFilterType((NotificationFilterPreference)pref, filterType) && this.matchAllEvents((NotificationFilterPreference)pref));
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the list of UserFilter notification preferences.", (Throwable)e);
            return Stream.empty();
        }
    }

    private boolean matchFormat(NotificationFilterPreference filterPreference, NotificationFormat format) {
        return format == null || filterPreference.getNotificationFormats().contains(format);
    }

    private boolean matchFilter(NotificationFilterPreference pref) {
        return pref.isEnabled() && "eventUserNotificationFilter".equals(pref.getFilterName());
    }

    private boolean matchFilterType(NotificationFilterPreference pref, NotificationFilterType filterType) {
        return pref.getFilterType() == filterType;
    }

    private boolean matchAllEvents(NotificationFilterPreference filterPreference) {
        return filterPreference.getEventTypes().isEmpty();
    }
}

