/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.user;

import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.AbstractBinaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.user.EventUserFilterPreferencesGetter;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.text.StringUtils;

@Component
@Singleton
@Named(value="eventUserNotificationFilter")
public class EventUserFilter
implements NotificationFilter {
    public static final String FILTER_NAME = "eventUserNotificationFilter";
    @Inject
    private EventUserFilterPreferencesGetter preferencesGetter;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        String eventUserId = (String)this.serializer.serialize((EntityReference)event.getUser(), new Object[0]);
        if (this.preferencesGetter.isUserExcluded(eventUserId, filterPreferences, format)) {
            return NotificationFilter.FilterPolicy.FILTER;
        }
        if (this.preferencesGetter.isUserFollowed(eventUserId, filterPreferences, format)) {
            return NotificationFilter.FilterPolicy.KEEP;
        }
        return NotificationFilter.FilterPolicy.NO_EFFECT;
    }

    @Override
    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (type == NotificationFilterType.EXCLUSIVE) {
            Collection<String> users = this.preferencesGetter.getExcludedUsers(filterPreferences, format);
            if (!users.isEmpty()) {
                return ExpressionBuilder.not(ExpressionBuilder.value(EventProperty.USER).inStrings(users));
            }
        } else {
            Iterator iterator = this.preferencesGetter.getFollowedUsersPreferences(filterPreferences, format).iterator();
            AbstractBinaryOperatorNode node = null;
            while (iterator.hasNext()) {
                NotificationFilterPreference pref = (NotificationFilterPreference)iterator.next();
                if (!StringUtils.isNotBlank((CharSequence)pref.getUser())) continue;
                AndNode thisNode = ExpressionBuilder.value(EventProperty.USER).eq(ExpressionBuilder.value(pref.getUser())).and(ExpressionBuilder.value(EventProperty.DATE).greaterThan(ExpressionBuilder.value(pref.getStartingDate())));
                if (node == null) {
                    node = thisNode;
                    continue;
                }
                node = node.or(thisNode);
            }
            if (node != null) {
                return node;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public int getPriority() {
        return 2000;
    }
}

