/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.status;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.filters.internal.status.ForUserNode;
import org.xwiki.notifications.preferences.NotificationPreference;

public abstract class AbstractForUserEventFilter
implements NotificationFilter,
ToggleableNotificationFilter {
    protected String filterName;
    protected NotificationFormat format;
    protected Boolean read;
    protected boolean not;

    public AbstractForUserEventFilter(String filterName, NotificationFormat format, Boolean read, boolean not) {
        this.filterName = filterName;
        this.format = format;
        this.read = read;
        this.not = not;
    }

    @Override
    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return NotificationFilter.FilterPolicy.NO_EFFECT;
    }

    @Override
    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (user != null && type == NotificationFilterType.EXCLUSIVE && format == this.format) {
            ForUserNode node = new ForUserNode(user, this.read, this.format);
            return this.not ? ExpressionBuilder.not(node) : node;
        }
        return null;
    }

    @Override
    public List<NotificationFormat> getFormats() {
        return Collections.singletonList(this.format);
    }

    @Override
    public String getName() {
        return this.filterName;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractForUserEventFilter that = (AbstractForUserEventFilter)o;
        return new EqualsBuilder().append(this.not, that.not).append((Object)this.filterName, (Object)that.filterName).append((Object)this.format, (Object)that.format).append((Object)this.read, (Object)that.read).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.filterName).append((Object)this.format).append((Object)this.read).append(this.not).toHashCode();
    }

    @Override
    public Set<NotificationFilter.FilteringPhase> getFilteringPhases() {
        return SUPPORT_ONLY_POST_FILTERING_PHASE;
    }
}

