/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.Date;

public class WatchedLocationState {
    private final WatchedState state;
    private Date startingDate;

    public WatchedLocationState() {
        this.state = WatchedState.NOT_SET;
    }

    public WatchedLocationState(WatchedState state, Date startingDate) {
        this.state = state;
        if (startingDate != null) {
            this.startingDate = this.truncateMilliseconds(startingDate);
        }
    }

    private Date truncateMilliseconds(Date startingDate) {
        long dateValue = startingDate.getTime() / 1000L;
        return new Date(dateValue * 1000L);
    }

    public WatchedState getState() {
        return this.state;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public static enum WatchedState {
        WATCHED,
        WATCHED_WITH_CHILDREN,
        WATCHED_BY_ANCESTOR,
        BLOCKED,
        BLOCKED_WITH_CHILDREN,
        BLOCKED_BY_ANCESTOR,
        CUSTOM,
        NOT_SET;

    }
}

