/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreferencesHierarchy;

@Component(roles={ScopeNotificationFilterPreferencesGetter.class})
@Singleton
public class ScopeNotificationFilterPreferencesGetter {
    @Inject
    private EntityReferenceResolver<String> entityReferenceResolver;

    public ScopeNotificationFilterPreferencesHierarchy getScopeFilterPreferences(Collection<NotificationFilterPreference> filterPreferences, String eventType, NotificationFormat format, boolean onlyGivenType, boolean onlyGivenFormat) {
        ArrayList<ScopeNotificationFilterPreference> results = new ArrayList<ScopeNotificationFilterPreference>();
        Stream<NotificationFilterPreference> filterPreferenceStream = filterPreferences.stream().filter(pref -> this.matchAllCriteria((NotificationFilterPreference)pref, eventType, format, onlyGivenType, onlyGivenFormat));
        Iterator iterator = filterPreferenceStream.iterator();
        while (iterator.hasNext()) {
            results.add(new ScopeNotificationFilterPreference((NotificationFilterPreference)iterator.next(), this.entityReferenceResolver));
        }
        return new ScopeNotificationFilterPreferencesHierarchy(results);
    }

    private boolean matchAllCriteria(NotificationFilterPreference pref, String eventType, NotificationFormat format, boolean onlyGivenType, boolean onlyGivenFormat) {
        if (!this.matchFilter(pref) || !this.matchFormat(pref, format, onlyGivenFormat)) {
            return false;
        }
        if (!(onlyGivenType || this.matchAllEvents(pref) || this.matchEventType(pref, eventType))) {
            return false;
        }
        if (onlyGivenType && eventType == null && !this.matchAllEvents(pref)) {
            return false;
        }
        return !onlyGivenType || eventType == null || this.matchEventType(pref, eventType);
    }

    private boolean matchFilter(NotificationFilterPreference pref) {
        return pref.isEnabled() && "scopeNotificationFilter".equals(pref.getFilterName());
    }

    private boolean matchFormat(NotificationFilterPreference filterPreference, NotificationFormat format, boolean onlyGivenFormat) {
        if (!onlyGivenFormat) {
            return format == null || filterPreference.getNotificationFormats().contains(format);
        }
        if (format == null) {
            return filterPreference.getNotificationFormats().isEmpty() || filterPreference.getNotificationFormats().equals(Set.of(NotificationFormat.values()));
        }
        return filterPreference.getNotificationFormats().equals(Set.of(format));
    }

    private boolean matchAllEvents(NotificationFilterPreference filterPreference) {
        return filterPreference.getEventTypes().isEmpty();
    }

    private boolean matchEventType(NotificationFilterPreference filterPreference, String eventType) {
        return eventType == null || filterPreference.getEventTypes().contains(eventType);
    }
}

