/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.text.XWikiToStringBuilder;

public class ScopeNotificationFilterPreference
implements NotificationFilterPreference {
    private NotificationFilterPreference filterPreference;
    private EntityReference scopeReference;
    private boolean hasParent;
    private List<ScopeNotificationFilterPreference> children = new ArrayList<ScopeNotificationFilterPreference>();

    public ScopeNotificationFilterPreference(NotificationFilterPreference filterPreference, EntityReferenceResolver<String> entityReferenceResolver) {
        this.filterPreference = filterPreference;
        if (StringUtils.isNotBlank((CharSequence)filterPreference.getPageOnly())) {
            this.scopeReference = entityReferenceResolver.resolve((Object)filterPreference.getPageOnly(), EntityType.DOCUMENT, new Object[0]);
        } else if (StringUtils.isNotBlank((CharSequence)filterPreference.getPage())) {
            this.scopeReference = entityReferenceResolver.resolve((Object)filterPreference.getPage(), EntityType.SPACE, new Object[0]);
        } else if (StringUtils.isNotBlank((CharSequence)filterPreference.getWiki())) {
            this.scopeReference = entityReferenceResolver.resolve((Object)filterPreference.getWiki(), EntityType.WIKI, new Object[0]);
        }
    }

    public void setHasParent(boolean hasParent) {
        this.hasParent = hasParent;
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public List<ScopeNotificationFilterPreference> getChildren() {
        return this.children;
    }

    public void addChild(ScopeNotificationFilterPreference child) {
        this.children.add(child);
        child.setHasParent(true);
    }

    public boolean isParentOf(ScopeNotificationFilterPreference other) {
        return this.isPotentialParent() && other.isPotentialChild() && other.getScopeReference().hasParent(this.getScopeReference());
    }

    public boolean isPotentialParent() {
        return this.getFilterType() == NotificationFilterType.EXCLUSIVE;
    }

    public boolean isPotentialChild() {
        return this.getFilterType() == NotificationFilterType.INCLUSIVE;
    }

    public EntityReference getScopeReference() {
        return this.scopeReference;
    }

    @Override
    public String getId() {
        return this.filterPreference.getId();
    }

    @Override
    public String getFilterName() {
        return this.filterPreference.getFilterName();
    }

    @Override
    public boolean isEnabled() {
        return this.filterPreference.isEnabled();
    }

    @Override
    public NotificationFilterType getFilterType() {
        return this.filterPreference.getFilterType();
    }

    @Override
    public Set<NotificationFormat> getNotificationFormats() {
        return this.filterPreference.getNotificationFormats();
    }

    @Override
    public Date getStartingDate() {
        return this.filterPreference.getStartingDate();
    }

    @Override
    public Set<String> getEventTypes() {
        return this.filterPreference.getEventTypes();
    }

    @Override
    public String getUser() {
        return this.filterPreference.getUser();
    }

    @Override
    public String getPageOnly() {
        return this.filterPreference.getPageOnly();
    }

    @Override
    public String getPage() {
        return this.filterPreference.getPage();
    }

    @Override
    public String getWiki() {
        return this.filterPreference.getWiki();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.filterPreference.setEnabled(enabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeNotificationFilterPreference that = (ScopeNotificationFilterPreference)o;
        return new EqualsBuilder().append(this.hasParent, that.hasParent).append((Object)this.filterPreference, (Object)that.filterPreference).append((Object)this.scopeReference, (Object)that.scopeReference).append(this.children, that.children).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.filterPreference).append((Object)this.scopeReference).append(this.hasParent).append(this.children).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("hasParent", this.hasParent).append("filterPreference", (Object)this.filterPreference).append("scopeReference", (Object)this.scopeReference).append("children", this.children).toString();
    }
}

