/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.ConcatNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.LocationOperatorNodeGenerator;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreferencesGetter;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreferencesHierarchy;

@Component(roles={ScopeNotificationFilterExpressionGenerator.class})
@Singleton
public class ScopeNotificationFilterExpressionGenerator {
    @Inject
    private ScopeNotificationFilterPreferencesGetter scopeNotificationFilterPreferencesGetter;
    @Inject
    private LocationOperatorNodeGenerator locationOperatorNodeGenerator;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public AbstractOperatorNode filterExpression(Collection<NotificationFilterPreference> filterPreferences, String eventType, NotificationFormat format, DocumentReference user) {
        AbstractOperatorNode topNode = null;
        ScopeNotificationFilterPreferencesHierarchy preferences = this.scopeNotificationFilterPreferencesGetter.getScopeFilterPreferences(filterPreferences, eventType, format, false, false);
        topNode = this.handleExclusiveFilters(topNode, preferences);
        topNode = this.handleTopLevelInclusiveFilters(topNode, preferences);
        return topNode;
    }

    private AbstractOperatorNode handleExclusiveFilters(AbstractOperatorNode node, ScopeNotificationFilterPreferencesHierarchy preferences) {
        AbstractOperatorNode topNode = node;
        Iterator<ScopeNotificationFilterPreference> it = preferences.getExclusiveFiltersThatHasNoParents();
        while (it.hasNext()) {
            ScopeNotificationFilterPreference pref = it.next();
            if (this.isPageOnly(pref)) continue;
            AbstractOperatorNode filterNode = this.generateNode(pref);
            for (ScopeNotificationFilterPreference childFilter : pref.getChildren()) {
                if (this.isPageOnly(childFilter)) continue;
                filterNode = filterNode.or(this.generateNode(childFilter));
            }
            if (topNode == null) {
                topNode = filterNode;
                continue;
            }
            topNode = topNode.and(filterNode);
        }
        return topNode;
    }

    private AbstractOperatorNode handleTopLevelInclusiveFilters(AbstractOperatorNode node, ScopeNotificationFilterPreferencesHierarchy preferences) {
        AbstractOperatorNode topNode = null;
        Iterator<ScopeNotificationFilterPreference> it = preferences.getInclusiveFiltersThatHasNoParents();
        while (it.hasNext()) {
            ScopeNotificationFilterPreference pref = it.next();
            if (this.isPageOnly(pref)) continue;
            if (topNode == null) {
                topNode = this.generateNode(pref);
                continue;
            }
            topNode = topNode.or(this.generateNode(pref));
        }
        if (node != null && topNode != null) {
            topNode = node.and(topNode);
        } else if (topNode == null && node != null) {
            topNode = node;
        }
        return topNode;
    }

    private boolean isPageOnly(ScopeNotificationFilterPreference pref) {
        return StringUtils.isNotBlank((CharSequence)pref.getPageOnly()) && Strings.CS.startsWith((CharSequence)pref.getId(), (CharSequence)"NFP_") && pref.getEventTypes().isEmpty();
    }

    private AbstractOperatorNode generateNode(ScopeNotificationFilterPreference scopeNotificationFilterPreference) {
        AbstractOperatorNode filterNode = this.locationOperatorNodeGenerator.generateNode(scopeNotificationFilterPreference.getScopeReference());
        if (scopeNotificationFilterPreference.getFilterType().equals((Object)NotificationFilterType.EXCLUSIVE)) {
            filterNode = ExpressionBuilder.not(filterNode);
        } else if (scopeNotificationFilterPreference.getStartingDate() != null) {
            filterNode = filterNode.and(ExpressionBuilder.value(EventProperty.DATE).greaterThan(ExpressionBuilder.value(scopeNotificationFilterPreference.getStartingDate())));
        }
        return filterNode;
    }

    @Deprecated(since="16.10.6,17.2.0RC1")
    public AbstractOperatorNode filterExpression(Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format, NotificationFilterType type, DocumentReference user) {
        if (!filterPreferences.stream().anyMatch(this.isAPageOnlyFilterPreferenceThatConcernAllEvents(format, type))) {
            return null;
        }
        Object subQuery = "SELECT nfp.pageOnly FROM DefaultNotificationFilterPreference nfp WHERE nfp.owner = :owner AND nfp.filterType = %d AND nfp.filterName = 'scopeNotificationFilter' AND nfp.pageOnly IS NOT NULL AND nfp.pageOnly <> '' AND (nfp.allEventTypes = '' OR nfp.allEventTypes IS NULL) AND nfp.%s = true AND nfp.enabled = true";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("owner", this.serializer.serialize((EntityReference)user, new Object[0]));
        String formatParameter = format == NotificationFormat.ALERT ? "alertEnabled" : "emailEnabled";
        ConcatNode expression = ExpressionBuilder.value(EventProperty.WIKI).concat(ExpressionBuilder.value(":")).concat(ExpressionBuilder.value(EventProperty.PAGE));
        if (type == NotificationFilterType.EXCLUSIVE) {
            String exclusion = String.format((String)subQuery, NotificationFilterType.EXCLUSIVE.ordinal(), formatParameter);
            return ExpressionBuilder.not(expression.inSubQuery(exclusion, parameters));
        }
        subQuery = (String)subQuery + " AND nfp.startingDate <= event.date";
        String inclusion = String.format((String)subQuery, NotificationFilterType.INCLUSIVE.ordinal(), formatParameter);
        return expression.inSubQuery(inclusion, parameters);
    }

    private Predicate<NotificationFilterPreference> isAPageOnlyFilterPreferenceThatConcernAllEvents(NotificationFormat format, NotificationFilterType type) {
        return nfp -> this.isEnabledAndStoredScopeNotificationFilterPreference((NotificationFilterPreference)nfp) && this.doesFilterTypeAndFormatMatch((NotificationFilterPreference)nfp, format, type) && StringUtils.isNotBlank((CharSequence)nfp.getPageOnly());
    }

    private boolean isEnabledAndStoredScopeNotificationFilterPreference(NotificationFilterPreference nfp) {
        return nfp.isEnabled() && "scopeNotificationFilter".equals(nfp.getFilterName()) && Strings.CS.startsWith((CharSequence)nfp.getId(), (CharSequence)"NFP_");
    }

    private boolean doesFilterTypeAndFormatMatch(NotificationFilterPreference nfp, NotificationFormat format, NotificationFilterType type) {
        return nfp.getFilterType() == type && nfp.getNotificationFormats().contains(format);
    }
}

