/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.scope;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.AbstractBinaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterExpressionGenerator;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterLocationStateComputer;
import org.xwiki.notifications.filters.internal.scope.WatchedLocationState;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;

@Component
@Named(value="scopeNotificationFilter")
@Singleton
public class ScopeNotificationFilter
implements NotificationFilter {
    public static final String FILTER_NAME = "scopeNotificationFilter";
    @Inject
    private ScopeNotificationFilterLocationStateComputer stateComputer;
    @Inject
    private ScopeNotificationFilterExpressionGenerator expressionGenerator;
    @Inject
    private Logger logger;

    @Override
    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        EntityReference eventEntity = this.getEventEntity(event);
        NotificationFilter.FilterPolicy result = NotificationFilter.FilterPolicy.NO_EFFECT;
        if (eventEntity != null) {
            boolean checkInclusiveFilters = event.getTarget() == null || event.getTarget().isEmpty();
            WatchedLocationState state = this.stateComputer.isLocationWatched(filterPreferences, eventEntity, event.getType(), format, false, checkInclusiveFilters, false);
            result = this.getFilterPolicy(event, user, state, checkInclusiveFilters);
        }
        return result;
    }

    private NotificationFilter.FilterPolicy getFilterPolicy(Event event, DocumentReference user, WatchedLocationState state, boolean checkInclusiveFilters) {
        NotificationFilter.FilterPolicy result = NotificationFilter.FilterPolicy.NO_EFFECT;
        switch (state.getState()) {
            case BLOCKED: 
            case BLOCKED_BY_ANCESTOR: 
            case BLOCKED_WITH_CHILDREN: {
                if (state.getStartingDate() == null || !state.getStartingDate().before(event.getDate())) break;
                result = NotificationFilter.FilterPolicy.FILTER;
                break;
            }
            case WATCHED: 
            case WATCHED_BY_ANCESTOR: 
            case WATCHED_WITH_CHILDREN: {
                if (state.getStartingDate() == null || !state.getStartingDate().after(event.getDate())) break;
                result = NotificationFilter.FilterPolicy.FILTER;
                break;
            }
            case CUSTOM: {
                this.logger.error("Filtering of event should never return custom. Event: [{}]. User: [{}] ", (Object)event, (Object)user);
                break;
            }
            default: {
                if (!checkInclusiveFilters) break;
                result = NotificationFilter.FilterPolicy.FILTER;
            }
        }
        return result;
    }

    @Override
    public boolean matchesPreference(NotificationPreference preference) {
        return preference.getCategory().equals((Object)NotificationPreferenceCategory.DEFAULT) && preference.getProperties().containsKey(NotificationPreferenceProperty.EVENT_TYPE);
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return this.expressionGenerator.filterExpression(filterPreferences, (String)preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE), preference.getFormat(), user);
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        return this.filterExpression(user, filterPreferences, type, format, Collections.emptyList());
    }

    @Override
    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format, Collection<NotificationPreference> preferences) {
        AbstractOperatorNode node = this.expressionGenerator.filterExpression(filterPreferences, format, type, user);
        if (node == null) {
            return null;
        }
        if (type == NotificationFilterType.INCLUSIVE) {
            AbstractOperatorNode enabledEventTypes = this.getEnabledEventTypes(preferences);
            if (enabledEventTypes != null) {
                return enabledEventTypes.and(node);
            }
        } else {
            return node;
        }
        return null;
    }

    private AbstractOperatorNode getEnabledEventTypes(Collection<NotificationPreference> preferences) {
        AbstractBinaryOperatorNode topNode = null;
        for (NotificationPreference preference : preferences) {
            Object eventType = preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE);
            if (!preference.isNotificationEnabled() || eventType == null || !(eventType instanceof String)) continue;
            AndNode node = ExpressionBuilder.value(EventProperty.TYPE).eq(ExpressionBuilder.value((String)eventType)).and(ExpressionBuilder.value(EventProperty.DATE).greaterThan(ExpressionBuilder.value(preference.getStartDate())));
            if (topNode == null) {
                topNode = node;
                continue;
            }
            topNode = topNode.or(node);
        }
        return topNode;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    private EntityReference getEventEntity(Event event) {
        if (event.getDocument() != null) {
            return event.getDocument();
        }
        if (event.getSpace() != null) {
            return event.getSpace();
        }
        return event.getWiki();
    }
}

