/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.listener;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="org.xwiki.notifications.filters.internal.listener.DeletedWikiEventListener")
public class DeletedWikiEventListener
extends AbstractEventListener {
    @Named(value="cached")
    @Inject
    private Provider<FilterPreferencesModelBridge> modelBridgeProvider;
    @Inject
    private Logger logger;

    public DeletedWikiEventListener() {
        super(DeletedWikiEventListener.class.getName(), new Event[]{new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        String wikiId = (String)source;
        try {
            ((FilterPreferencesModelBridge)this.modelBridgeProvider.get()).deleteFilterPreferences(new WikiReference(wikiId));
        }
        catch (NotificationException e) {
            this.logger.warn("Failed to delete notification preferences for wiki [{}]. Cause: [{}].", (Object)wikiId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

