/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.listener;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="org.xwiki.notifications.filters.internal.listener.DeleteUserEventListener")
public class DeleteUserEventListener
extends AbstractEventListener {
    @Named(value="cached")
    @Inject
    private Provider<FilterPreferencesModelBridge> modelBridgeProvider;
    @Inject
    private Logger logger;

    public DeleteUserEventListener() {
        super(DeleteUserEventListener.class.getName(), new Event[]{new XObjectDeletedEvent((EntityReference)BaseObjectReference.any((String)XWikiUsersDocumentInitializer.CLASS_REFERENCE_STRING))});
    }

    public void onEvent(Event event, Object source, Object data) {
        DocumentReference user = ((XWikiDocument)source).getDocumentReference();
        try {
            ((FilterPreferencesModelBridge)this.modelBridgeProvider.get()).deleteFilterPreferences(user);
        }
        catch (NotificationException e) {
            this.logger.warn("Failed to delete notification preferences for user [{}]. Cause: [{}].", (Object)user, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

