/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;

@Component(roles={LocationOperatorNodeGenerator.class})
@Singleton
public class LocationOperatorNodeGenerator {
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;

    public AbstractOperatorNode generateNode(EntityReference location) {
        String wiki = location.extractReference(EntityType.WIKI).getName();
        String serializedLocation = (String)this.localSerializer.serialize(location, new Object[0]);
        switch (location.getType()) {
            case DOCUMENT: {
                return ExpressionBuilder.value(EventProperty.WIKI).eq(ExpressionBuilder.value(wiki)).and(ExpressionBuilder.value(EventProperty.PAGE).eq(ExpressionBuilder.value(serializedLocation)));
            }
            case SPACE: {
                return ExpressionBuilder.value(EventProperty.WIKI).eq(ExpressionBuilder.value(wiki)).and(ExpressionBuilder.value(EventProperty.SPACE).startsWith(ExpressionBuilder.value(serializedLocation)));
            }
            case WIKI: {
                return ExpressionBuilder.value(EventProperty.WIKI).eq(ExpressionBuilder.value(wiki));
            }
        }
        return null;
    }
}

