/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterManager;

@Component
@Singleton
public class LegacyDefaultNotificationFilterManager
extends DefaultNotificationFilterManager {
    @Inject
    private NotificationConfiguration configuration;

    @Override
    public Collection<NotificationFilter> getAllFilters(DocumentReference user, boolean onlyEnabled, NotificationFilter.FilteringPhase filteringPhase) throws NotificationException {
        if (this.configuration.isEventPrefilteringEnabled()) {
            return super.getAllFilters(user, onlyEnabled, filteringPhase);
        }
        Collection<NotificationFilter> filters = this.getAllFilters(user.getWikiReference().getName().equals(this.wikiDescriptorManager.getMainWikiId()));
        Map<String, Boolean> filterActivations = this.getToggeableFilterActivations(user);
        Iterator<NotificationFilter> it = filters.iterator();
        while (it.hasNext()) {
            boolean filterActivation;
            NotificationFilter filter = it.next();
            if (this.legacyShouldFilterBeSelected(filter, filterActivation = filterActivations.getOrDefault(filter.getName(), true).booleanValue(), onlyEnabled, filteringPhase, false)) continue;
            it.remove();
        }
        return filters;
    }

    private boolean legacyShouldFilterBeSelected(NotificationFilter filter, boolean filterActivation, boolean onlyEnabled, NotificationFilter.FilteringPhase filteringPhase, boolean onlyExactPhase) {
        return this.legacyShouldFilterBeSelectedBasedOnStatus(filterActivation, onlyEnabled) && this.legacyShouldFilterBeSelectedBasedOnFilteringPhase(filter, filteringPhase, onlyExactPhase);
    }

    private boolean legacyShouldFilterBeSelectedBasedOnStatus(boolean filterActivation, boolean onlyEnabled) {
        boolean result = false;
        if (!onlyEnabled) {
            result = true;
        } else if (filterActivation) {
            result = true;
        }
        return result;
    }

    private boolean legacyShouldFilterBeSelectedBasedOnFilteringPhase(NotificationFilter filter, NotificationFilter.FilteringPhase filteringPhase, boolean prefilteringEnabled) {
        Set<NotificationFilter.FilteringPhase> filterFilteringPhases = filter.getFilteringPhases();
        boolean result = filteringPhase == null ? true : (filterFilteringPhases == null || filterFilteringPhases.isEmpty() ? false : (prefilteringEnabled && filteringPhase == NotificationFilter.FilteringPhase.POST_FILTERING ? Collections.singleton(NotificationFilter.FilteringPhase.POST_FILTERING).equals(filterFilteringPhases) : (!prefilteringEnabled && filteringPhase == NotificationFilter.FilteringPhase.PRE_FILTERING ? false : filterFilteringPhases.contains((Object)filteringPhase))));
        return result;
    }
}

