/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.filters.internal.DeletedDocumentCleanUpFilterProcessingQueue;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamingEvent;
import org.xwiki.user.internal.group.UsersCache;

@Component
@Named(value="org.xwiki.notifications.notifiers.internal.DeletedDocumentCleanUpFilterListener")
@Singleton
public class DeletedDocumentCleanUpFilterListener
extends AbstractLocalEventListener {
    static final String NAME = "org.xwiki.notifications.notifiers.internal.DeletedDocumentCleanUpFilterListener";
    private static final BeginFoldEvent FOLDED_EVENTS = otherEvent -> otherEvent instanceof BeginFoldEvent;
    private static final DocumentRenamingEvent DOCUMENT_RENAMING_EVENT = new DocumentRenamingEvent();
    @Inject
    private ObservationContext observationContext;
    @Inject
    private Provider<DeletedDocumentCleanUpFilterProcessingQueue> cleanUpFilterProcessingQueueProvider;
    @Inject
    private Provider<UsersCache> usersCacheProvider;

    public DeletedDocumentCleanUpFilterListener() {
        super(NAME, new Event[]{new DocumentDeletedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        if (this.observationContext.isIn((BeginEvent)FOLDED_EVENTS) && !this.observationContext.isIn((BeginEvent)DOCUMENT_RENAMING_EVENT)) {
            DocumentDeletedEvent documentDeletedEvent = (DocumentDeletedEvent)event;
            DocumentReference documentReference = documentDeletedEvent.getDocumentReference();
            List users = ((UsersCache)this.usersCacheProvider.get()).getUsers(documentReference.getWikiReference(), false);
            for (DocumentReference user : users) {
                ((DeletedDocumentCleanUpFilterProcessingQueue)this.cleanUpFilterProcessingQueueProvider.get()).addCleanUpTask(user, documentReference);
            }
        }
    }
}

