/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterDisplayer;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilterActivation;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.rendering.block.Block;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultNotificationFilterManager
implements NotificationFilterManager {
    private static final String ERROR_MESSAGE = "Failed to get all the notification filters.";
    @Inject
    protected WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ModelContext modelContext;
    @Inject
    private NotificationFilterDisplayer defaultNotificationFilterDisplayer;
    @Inject
    @Named(value="cached")
    private FilterPreferencesModelBridge filterPreferencesModelBridge;

    @Override
    public Collection<NotificationFilter> getAllFilters(boolean allWikis) throws NotificationException {
        if (allWikis) {
            String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
            HashMap filters = new HashMap();
            try {
                for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                    this.modelContext.setCurrentEntityReference((EntityReference)new WikiReference(wikiId));
                    filters.putAll(this.componentManager.getInstanceMap(NotificationFilter.class));
                }
            }
            catch (Exception e) {
                throw new NotificationException(ERROR_MESSAGE, (Throwable)e);
            }
            finally {
                this.modelContext.setCurrentEntityReference((EntityReference)new WikiReference(currentWikiId));
            }
            return new HashSet<NotificationFilter>(filters.values());
        }
        try {
            return new HashSet<NotificationFilter>(this.componentManager.getInstanceList(NotificationFilter.class));
        }
        catch (Exception e) {
            throw new NotificationException(ERROR_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Collection<NotificationFilter> getAllFilters(WikiReference wikiReference) throws NotificationException {
        List filters;
        WikiReference currentWikiReference = this.wikiDescriptorManager.getCurrentWikiReference();
        try {
            this.modelContext.setCurrentEntityReference((EntityReference)wikiReference);
            filters = this.componentManager.getInstanceList(NotificationFilter.class);
        }
        catch (Exception e) {
            throw new NotificationException(ERROR_MESSAGE, (Throwable)e);
        }
        finally {
            this.modelContext.setCurrentEntityReference((EntityReference)currentWikiReference);
        }
        return new HashSet<NotificationFilter>(filters);
    }

    @Override
    public Collection<NotificationFilter> getAllFilters(DocumentReference user, boolean onlyEnabled) throws NotificationException {
        return this.getAllFilters(user, onlyEnabled, null);
    }

    @Override
    public Collection<NotificationFilter> getAllFilters(DocumentReference user, boolean onlyEnabled, NotificationFilter.FilteringPhase filteringPhase) throws NotificationException {
        Collection<NotificationFilter> filters = this.getAllFilters(user.getWikiReference().getName().equals(this.wikiDescriptorManager.getMainWikiId()));
        Map<String, Boolean> filterActivations = this.getToggeableFilterActivations(user);
        Iterator<NotificationFilter> it = filters.iterator();
        while (it.hasNext()) {
            boolean filterActivation;
            NotificationFilter filter = it.next();
            if (this.shouldFilterBeSelected(filter, filterActivation = filterActivations.getOrDefault(filter.getName(), true).booleanValue(), onlyEnabled, filteringPhase)) continue;
            it.remove();
        }
        return filters;
    }

    private boolean shouldFilterBeSelected(NotificationFilter filter, boolean filterActivation, boolean onlyEnabled, NotificationFilter.FilteringPhase filteringPhase) {
        return this.shouldFilterBeSelectedBasedOnStatus(filterActivation, onlyEnabled) && this.shouldFilterBeSelectedBasedOnFilteringPhase(filter, filteringPhase);
    }

    private boolean shouldFilterBeSelectedBasedOnStatus(boolean filterActivation, boolean onlyEnabled) {
        boolean result = false;
        if (!onlyEnabled) {
            result = true;
        } else if (filterActivation) {
            result = true;
        }
        return result;
    }

    private boolean shouldFilterBeSelectedBasedOnFilteringPhase(NotificationFilter filter, NotificationFilter.FilteringPhase filteringPhase) {
        Set<NotificationFilter.FilteringPhase> filterFilteringPhases = filter.getFilteringPhases();
        boolean result = filteringPhase == null ? true : (filterFilteringPhases == null || filterFilteringPhases.isEmpty() ? false : (filteringPhase == NotificationFilter.FilteringPhase.POST_FILTERING ? Collections.singleton(NotificationFilter.FilteringPhase.POST_FILTERING).equals(filterFilteringPhases) : filterFilteringPhases.contains((Object)filteringPhase)));
        return result;
    }

    @Override
    public Stream<NotificationFilter> getFiltersRelatedToNotificationPreference(Collection<NotificationFilter> filters, NotificationPreference preference) {
        return filters.stream().filter(filter -> filter.matchesPreference(preference));
    }

    @Override
    public Stream<NotificationFilter> getToggleableFilters(Collection<NotificationFilter> filters) {
        return filters.stream().filter(filter -> filter instanceof ToggleableNotificationFilter);
    }

    @Override
    public Map<String, Boolean> getToggeableFilterActivations(DocumentReference user) throws NotificationException {
        return this.filterPreferencesModelBridge.getToggleableFilterActivations(user).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ToggleableNotificationFilterActivation)entry.getValue()).isEnabled()));
    }

    @Override
    public Stream<NotificationFilter> getEnabledFilters(Collection<NotificationFilter> filters, Map<String, Boolean> filterActivations) {
        return filters.stream().filter(filter -> {
            if (filter instanceof ToggleableNotificationFilter && filterActivations.containsKey(filter.getName())) {
                return (Boolean)filterActivations.get(filter.getName());
            }
            return true;
        });
    }

    @Override
    public Block displayFilter(NotificationFilter filter, NotificationFilterPreference preference) throws NotificationException {
        try {
            List renderers = this.componentManager.getInstanceList(NotificationFilterDisplayer.class);
            for (NotificationFilterDisplayer renderer : renderers) {
                if (!renderer.getSupportedFilters().contains(filter.getName())) continue;
                return renderer.display(filter, preference);
            }
            return this.defaultNotificationFilterDisplayer.display(filter, preference);
        }
        catch (ComponentLookupException e) {
            throw new NotificationException(String.format("Unable get a list of NotificationFilterDisplayer for filter [%s].", filter), (Throwable)e);
        }
    }
}

