/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.AbstractNotificationFilterDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultNotificationFilterDisplayer
extends AbstractNotificationFilterDisplayer {
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;

    @Override
    public Block display(NotificationFilter filter, NotificationFilterPreference preference) throws NotificationException {
        Map<String, Object> backup = this.setUpContext(this.scriptContextManager, filter, preference);
        try {
            String templateName = String.format("notification/filters/%s.vm", filter.getName().replaceAll("\\/", "."));
            Template template = this.templateManager.getTemplate(templateName);
            XDOM xDOM = template != null ? this.templateManager.execute(template) : this.templateManager.execute("notification/filters/default.vm");
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to display the notification filter [%s] with the filter preference [%s].", filter, preference), (Throwable)e);
        }
        finally {
            this.cleanUpContext(this.scriptContextManager, backup);
        }
    }

    @Override
    public Set<String> getSupportedFilters() {
        return Collections.emptySet();
    }
}

