/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilterActivation;
import org.xwiki.notifications.preferences.internal.cache.UnboundedEntityCacheManager;

@Component
@Named(value="cached")
@Singleton
public class CachedFilterPreferencesModelBridge
implements FilterPreferencesModelBridge,
Initializable {
    private static final String PREFERENCEFILTERCACHE_NAME = "NotificationsFilterPreferences";
    private static final String TOGGLECACHE_NAME = "ToggeableFilterActivations";
    @Inject
    private FilterPreferencesModelBridge filterPreferencesModelBridge;
    @Inject
    private UnboundedEntityCacheManager cacheManager;
    @Inject
    private EntityReferenceFactory referenceFactory;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private Map<EntityReference, Set<NotificationFilterPreference>> preferenceFilterCache;
    private Map<EntityReference, Map<String, ToggleableNotificationFilterActivation>> toggleCache;

    void invalidatePreferencefilter(EntityReference reference) {
        this.preferenceFilterCache.remove(reference);
    }

    public void initialize() throws InitializationException {
        this.preferenceFilterCache = this.cacheManager.createCache(PREFERENCEFILTERCACHE_NAME, false);
        this.toggleCache = this.cacheManager.createCache(TOGGLECACHE_NAME, true);
    }

    @Override
    public Set<NotificationFilterPreference> getFilterPreferences(DocumentReference userReference) throws NotificationException {
        if (userReference == null) {
            return Collections.emptySet();
        }
        Set<NotificationFilterPreference> preferences = this.preferenceFilterCache.get(userReference);
        if (preferences != null) {
            return preferences;
        }
        preferences = this.filterPreferencesModelBridge.getFilterPreferences(userReference);
        this.preferenceFilterCache.put(this.referenceFactory.getReference((EntityReference)userReference), preferences);
        return preferences;
    }

    @Override
    public Set<NotificationFilterPreference> getFilterPreferences(WikiReference wikiReference) throws NotificationException {
        if (wikiReference == null) {
            return Collections.emptySet();
        }
        Set<NotificationFilterPreference> preferences = this.preferenceFilterCache.get(wikiReference);
        if (preferences != null) {
            return preferences;
        }
        preferences = this.filterPreferencesModelBridge.getFilterPreferences(wikiReference);
        this.preferenceFilterCache.put(this.referenceFactory.getReference((EntityReference)wikiReference), preferences);
        return preferences;
    }

    @Override
    public Map<String, ToggleableNotificationFilterActivation> getToggleableFilterActivations(DocumentReference userReference) throws NotificationException {
        Map<String, ToggleableNotificationFilterActivation> values = this.toggleCache.get(userReference);
        if (values != null) {
            return values;
        }
        values = this.filterPreferencesModelBridge.getToggleableFilterActivations(userReference);
        this.toggleCache.put(this.referenceFactory.getReference((EntityReference)userReference), values);
        return values;
    }

    @Override
    public void deleteFilterPreference(DocumentReference user, String filterPreferenceId) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreference(user, filterPreferenceId);
    }

    @Override
    public void deleteFilterPreferences(DocumentReference user, Set<String> filterPreferenceIds) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreferences(user, filterPreferenceIds);
    }

    @Override
    public void deleteFilterPreferences(DocumentReference user) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreferences(user);
        this.invalidateUserPreferencesFilters(user);
    }

    @Override
    public void deleteFilterPreference(WikiReference wikiReference, String filterPreferenceId) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreference(wikiReference, filterPreferenceId);
    }

    @Override
    public void deleteFilterPreferences(WikiReference wikiReference) throws NotificationException {
        this.filterPreferencesModelBridge.deleteFilterPreferences(wikiReference);
        this.invalidateWikiPreferenceFilters(wikiReference);
    }

    @Override
    public void setFilterPreferenceEnabled(DocumentReference user, String filterPreferenceId, boolean enabled) throws NotificationException {
        this.filterPreferencesModelBridge.setFilterPreferenceEnabled(user, filterPreferenceId, enabled);
    }

    @Override
    public void setFilterPreferenceEnabled(WikiReference wikiReference, String filterPreferenceId, boolean enabled) throws NotificationException {
        this.filterPreferencesModelBridge.setFilterPreferenceEnabled(wikiReference, filterPreferenceId, enabled);
    }

    @Override
    public void saveFilterPreferences(WikiReference wikiReference, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.filterPreferencesModelBridge.saveFilterPreferences(wikiReference, filterPreferences);
    }

    @Override
    public void saveFilterPreferences(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.filterPreferencesModelBridge.saveFilterPreferences(user, filterPreferences);
    }

    @Override
    public void setStartDateForUser(DocumentReference user, Date startDate) throws NotificationException {
        this.filterPreferencesModelBridge.setStartDateForUser(user, startDate);
    }

    @Override
    public void createScopeFilterPreference(DocumentReference user, NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        this.filterPreferencesModelBridge.createScopeFilterPreference(user, type, formats, eventTypes, reference);
    }

    @Override
    public void createScopeFilterPreference(WikiReference wikiReference, NotificationFilterType type, Set<NotificationFormat> formats, List<String> eventTypes, EntityReference reference) throws NotificationException {
        this.filterPreferencesModelBridge.createScopeFilterPreference(wikiReference, type, formats, eventTypes, reference);
    }

    public void clearCache() {
        this.preferenceFilterCache.clear();
        this.toggleCache.clear();
    }

    private void invalidateWikiPreferenceFilters(WikiReference wikiReference) {
        this.preferenceFilterCache.values().forEach(set -> set.removeIf(filter -> filter.isFromWiki(wikiReference.getName())));
    }

    private void invalidateUserPreferencesFilters(DocumentReference user) {
        String serializedUserReference = (String)this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]);
        this.preferenceFilterCache.remove(user);
        this.preferenceFilterCache.values().forEach(set -> set.removeIf(filter -> Objects.equals(filter.getUser(), serializedUserReference)));
    }
}

