/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.expression.generics;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.xwiki.notifications.filters.expression.ConcatNode;
import org.xwiki.notifications.filters.expression.EndsWith;
import org.xwiki.notifications.filters.expression.EqualsNode;
import org.xwiki.notifications.filters.expression.GreaterThanNode;
import org.xwiki.notifications.filters.expression.InNode;
import org.xwiki.notifications.filters.expression.InSubQueryNode;
import org.xwiki.notifications.filters.expression.LesserThanNode;
import org.xwiki.notifications.filters.expression.NotEqualsNode;
import org.xwiki.notifications.filters.expression.StartsWith;
import org.xwiki.notifications.filters.expression.StringValueNode;
import org.xwiki.notifications.filters.expression.generics.AbstractNode;

public abstract class AbstractValueNode<T>
extends AbstractNode {
    private T content;

    public AbstractValueNode(T content) {
        if (content == null) {
            throw new NullPointerException("A value node should have its content defined.");
        }
        this.content = content;
    }

    public EqualsNode eq(AbstractValueNode node) {
        return new EqualsNode(this, node);
    }

    public NotEqualsNode notEq(AbstractValueNode node) {
        return new NotEqualsNode(this, node);
    }

    public StartsWith startsWith(AbstractValueNode node) {
        return new StartsWith(this, node);
    }

    public EndsWith endsWith(AbstractValueNode node) {
        return new EndsWith(this, node);
    }

    public GreaterThanNode greaterThan(AbstractValueNode node) {
        return new GreaterThanNode(this, node);
    }

    public LesserThanNode lesserThan(AbstractValueNode node) {
        return new LesserThanNode(this, node);
    }

    public InNode in(Collection<AbstractValueNode> values) {
        return new InNode(this, values);
    }

    public InNode inStrings(Collection<String> values) {
        return this.in(values.stream().map(s -> new StringValueNode((String)s)).collect(Collectors.toList()));
    }

    public InSubQueryNode inSubQuery(String subQuery, Map<String, Object> parameters) {
        return new InSubQueryNode(this, subQuery, parameters);
    }

    public ConcatNode concat(AbstractValueNode node) {
        return new ConcatNode(this, node);
    }

    public T getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractValueNode && this.content.equals(((AbstractValueNode)o).content);
    }

    public int hashCode() {
        return 13 + this.content.hashCode();
    }
}

