/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.expression;

import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.notifications.filters.expression.generics.AbstractNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;

public final class InNode
extends AbstractOperatorNode {
    private AbstractValueNode leftOperand;
    private Collection<AbstractValueNode> values;

    public InNode(AbstractValueNode leftOperand, Collection<AbstractValueNode> values) {
        this.leftOperand = leftOperand;
        this.values = values;
    }

    public AbstractNode getLeftOperand() {
        return this.leftOperand;
    }

    public Collection<AbstractValueNode> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InNode inNode = (InNode)o;
        return new EqualsBuilder().append((Object)this.leftOperand, (Object)inNode.leftOperand).append(this.values, inNode.values).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.leftOperand).append(this.values).toHashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.leftOperand.toString());
        s.append(" IN (");
        String separator = "";
        for (AbstractValueNode value : this.values) {
            s.append(separator);
            s.append(value.toString());
            separator = ", ";
        }
        s.append(")");
        return s.toString();
    }
}

