/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.CompatibilityNotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.stability.Unstable;

public interface NotificationFilterPreference
extends CompatibilityNotificationFilterPreference {
    @Unstable
    public static final String DB_ID_FILTER_PREFIX = "NFP_";

    public String getId();

    public String getFilterName();

    public boolean isEnabled();

    @Deprecated(since="16.5.0RC1")
    default public boolean isActive() {
        return true;
    }

    public NotificationFilterType getFilterType();

    public Set<NotificationFormat> getNotificationFormats();

    public Date getStartingDate();

    public Set<String> getEventTypes();

    public String getUser();

    public String getPageOnly();

    public String getPage();

    public String getWiki();

    public void setEnabled(boolean var1);

    default public boolean isFromWiki(String wikiId) {
        String wikiIdWithPrefix = wikiId + ":";
        return Objects.equals(this.getWiki(), wikiId) || Strings.CS.startsWith((CharSequence)this.getPage(), (CharSequence)wikiIdWithPrefix) || Strings.CS.startsWith((CharSequence)this.getPageOnly(), (CharSequence)wikiIdWithPrefix) || Strings.CS.startsWith((CharSequence)this.getUser(), (CharSequence)wikiIdWithPrefix);
    }

    default public Optional<String> getWikiId() {
        String wikiId = null;
        if (this.getWiki() != null) {
            wikiId = this.getWiki();
        } else if (this.getPage() != null) {
            wikiId = StringUtils.substringBefore((String)this.getPage(), (String)":");
        } else if (this.getPageOnly() != null) {
            wikiId = StringUtils.substringBefore((String)this.getPageOnly(), (String)":");
        } else if (this.getUser() != null) {
            wikiId = StringUtils.substringBefore((String)this.getUser(), (String)":");
        }
        return Optional.ofNullable(wikiId);
    }
}

