/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.xwiki.component.annotation.Role;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.preferences.NotificationPreference;

@Role
public interface NotificationFilter
extends Comparable {
    public static final Set<FilteringPhase> SUPPORT_BOTH_FILTERING_PHASE = EnumSet.of(FilteringPhase.PRE_FILTERING, FilteringPhase.POST_FILTERING);
    public static final Set<FilteringPhase> SUPPORT_ONLY_POST_FILTERING_PHASE = Collections.singleton(FilteringPhase.POST_FILTERING);
    public static final Set<FilteringPhase> SUPPORT_ONLY_PRE_FILTERING_PHASE = Collections.singleton(FilteringPhase.PRE_FILTERING);

    public FilterPolicy filterEvent(Event var1, DocumentReference var2, Collection<NotificationFilterPreference> var3, NotificationFormat var4);

    public boolean matchesPreference(NotificationPreference var1);

    public ExpressionNode filterExpression(DocumentReference var1, Collection<NotificationFilterPreference> var2, NotificationPreference var3);

    public ExpressionNode filterExpression(DocumentReference var1, Collection<NotificationFilterPreference> var2, NotificationFilterType var3, NotificationFormat var4);

    default public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format, Collection<NotificationPreference> preferences) {
        return this.filterExpression(user, filterPreferences, type, format);
    }

    public String getName();

    default public int getPriority() {
        return 1000;
    }

    default public int compareTo(Object o) {
        if (o instanceof NotificationFilter) {
            NotificationFilter other = (NotificationFilter)o;
            return other.getPriority() - this.getPriority();
        }
        return 0;
    }

    default public Set<FilteringPhase> getFilteringPhases() {
        return SUPPORT_BOTH_FILTERING_PHASE;
    }

    public static enum FilteringPhase {
        POST_FILTERING,
        PRE_FILTERING;

    }

    public static enum FilterPolicy {
        FILTER,
        KEEP,
        NO_EFFECT;

    }
}

