/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventStrategy;
import org.xwiki.notifications.NotificationException;

@Component
@Named(value="applicationtype")
@Singleton
public class ApplicationTypeGroupingStrategy
implements GroupingEventStrategy {
    @Override
    public List<CompositeEvent> group(List<Event> eventList) throws NotificationException {
        HashMap<String, CompositeEvent> compositeEventMap = new HashMap<String, CompositeEvent>();
        for (Event event : eventList) {
            CompositeEvent compositeEvent;
            String eventType = event.getType();
            if (compositeEventMap.containsKey(eventType)) {
                compositeEvent = (CompositeEvent)compositeEventMap.get(eventType);
                compositeEvent.add(event);
                continue;
            }
            compositeEvent = new CompositeEvent(event);
            compositeEventMap.put(eventType, compositeEvent);
        }
        return new ArrayList<CompositeEvent>(compositeEventMap.values());
    }

    @Override
    public void group(List<CompositeEvent> compositeEvents, List<Event> newEvents) throws NotificationException {
        HashMap<String, CompositeEvent> compositeEventMap = new HashMap<String, CompositeEvent>();
        for (CompositeEvent compositeEvent : compositeEvents) {
            compositeEventMap.put(compositeEvent.getType(), compositeEvent);
        }
        for (Event event : newEvents) {
            CompositeEvent compositeEvent;
            String eventType = event.getType();
            if (compositeEventMap.containsKey(eventType)) {
                compositeEvent = (CompositeEvent)compositeEventMap.get(eventType);
                compositeEvent.add(event);
                continue;
            }
            compositeEvent = new CompositeEvent(event);
            compositeEventMap.put(eventType, compositeEvent);
            compositeEvents.add(compositeEvent);
        }
    }
}

