/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.text.StringUtils;

public class CompositeEvent {
    private List<Event> events = new ArrayList<Event>();
    private int similarityBetweenEvents;

    public CompositeEvent(Event event) {
        this.events.add(event);
    }

    public CompositeEvent(CompositeEvent compositeEvent) {
        this.events = new ArrayList<Event>(compositeEvent.events);
        this.similarityBetweenEvents = compositeEvent.similarityBetweenEvents;
    }

    public List<String> getEventIds() {
        ArrayList<String> results = new ArrayList<String>(this.events.size());
        for (Event event : this.events) {
            results.add(event.getId());
        }
        return results;
    }

    @Deprecated(since="15.5RC1")
    public void add(Event event, int similarity) throws NotificationException {
        if (similarity < this.similarityBetweenEvents) {
            throw new NotificationException("Invalid addition of an event inside a CompositeEvent");
        }
        this.similarityBetweenEvents = similarity;
        this.add(event);
    }

    public void add(Event event) {
        this.events.add(event);
        Collections.sort(this.events, (e1, e2) -> e2.getDate().compareTo(e1.getDate()));
    }

    @Deprecated(since="15.5RC1")
    public int getSimilarityBetweenEvents() {
        return this.similarityBetweenEvents;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public String getType() {
        String type = this.events.get(0).getType();
        for (Event event : this.events) {
            if (!StringUtils.isNotBlank((CharSequence)event.getType()) || "create".equals(event.getType()) || "update".equals(event.getType())) continue;
            type = event.getType();
        }
        return type;
    }

    public String getGroupId() {
        return this.events.get(0).getGroupId();
    }

    public DocumentReference getDocument() {
        return this.events.get(0).getDocument();
    }

    public Set<DocumentReference> getUsers() {
        LinkedHashSet<DocumentReference> users = new LinkedHashSet<DocumentReference>();
        for (Event event : this.events) {
            users.add(event.getUser());
        }
        return users;
    }

    public Date getDate() {
        Iterator<Event> it = this.events.iterator();
        Event chosenEvent = it.next();
        while (it.hasNext()) {
            Event event = it.next();
            if (event.getDate().compareTo(chosenEvent.getDate()) <= 0) continue;
            chosenEvent = event;
        }
        return chosenEvent.getDate();
    }

    public List<Date> getDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (Event event : this.events) {
            dates.add(event.getDate());
        }
        Collections.sort(dates, Collections.reverseOrder());
        return dates;
    }

    public void remove(Event event) {
        this.events.remove(event);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CompositeEvent) {
            CompositeEvent compositeEvent = (CompositeEvent)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.getSimilarityBetweenEvents(), compositeEvent.getSimilarityBetweenEvents());
            builder.append(this.getEvents(), compositeEvent.getEvents());
            return builder.build();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getSimilarityBetweenEvents());
        builder.append(this.getEvents());
        return builder.build();
    }
}

