/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.messagestream.internal.AbstractMessageStreamNotificationFilter;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;

@Component
@Singleton
@Named(value="DirectMessageStreamNotificationFilter")
public class DirectMessageStreamNotificationFilter
extends AbstractMessageStreamNotificationFilter {
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        if (!this.getEventType().equals(event.getType())) {
            return NotificationFilter.FilterPolicy.NO_EFFECT;
        }
        if (user != null) {
            String userId = (String)this.serializer.serialize((EntityReference)user, new Object[0]);
            return userId.equals(event.getStream()) ? NotificationFilter.FilterPolicy.NO_EFFECT : NotificationFilter.FilterPolicy.FILTER;
        }
        return NotificationFilter.FilterPolicy.FILTER;
    }

    public String getName() {
        return "Direct Message Stream Notification Filter";
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    String getEventType() {
        return "directMessage";
    }
}

