/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.messagestream.MessageStream;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;

@Component
@Singleton
public class DefaultMessageStream
implements MessageStream {
    private static final String EVENT_APPLICATION = "MessageStream";
    @Inject
    private ModelContext context;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private EventStore eventStore;
    @Inject
    private EventFactory factory;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private Logger logger;

    @Override
    public void postPublicMessage(String message) {
        Event e = this.createMessageEvent(message, "publicMessage");
        DocumentReference userDoc = this.bridge.getCurrentUserReference();
        e.setRelatedEntity((EntityReference)userDoc);
        e.setImportance(Event.Importance.MINOR);
        e.setStream((String)this.serializer.serialize((EntityReference)userDoc, new Object[0]));
        e.setTitle("messagestream.descriptors.rss.publicMessage.title");
        this.saveEvent(e);
    }

    @Override
    public void postPersonalMessage(String message) {
        Event e = this.createMessageEvent(message, "personalMessage");
        DocumentReference userDoc = this.bridge.getCurrentUserReference();
        e.setRelatedEntity((EntityReference)userDoc);
        e.setStream((String)this.serializer.serialize((EntityReference)userDoc, new Object[0]));
        e.setTitle("messagestream.descriptors.rss.personalMessage.title");
        this.saveEvent(e);
    }

    @Override
    public void postDirectMessageToUser(String message, DocumentReference user) {
        if (!this.exists(user)) {
            throw new IllegalArgumentException("Target user does not exist");
        }
        Event e = this.createMessageEvent(message, "directMessage");
        e.setRelatedEntity((EntityReference)new ObjectReference("XWiki.XWikiUsers", user));
        e.setStream((String)this.serializer.serialize((EntityReference)user, new Object[0]));
        e.setImportance(Event.Importance.CRITICAL);
        e.setTitle("messagestream.descriptors.rss.directMessage.title");
        this.saveEvent(e);
    }

    @Override
    public void postMessageToGroup(String message, DocumentReference group) throws IllegalAccessError {
        if (!this.exists(group)) {
            throw new IllegalArgumentException("Target group does not exist");
        }
        Event e = this.createMessageEvent(message, "groupMessage");
        e.setRelatedEntity((EntityReference)new ObjectReference("XWiki.XWikiGroups", group));
        e.setStream((String)this.serializer.serialize((EntityReference)group, new Object[0]));
        e.setImportance(Event.Importance.MAJOR);
        e.setTitle("messagestream.descriptors.rss.groupMessage.title");
        this.saveEvent(e);
    }

    private boolean exists(DocumentReference userReference) throws IllegalAccessError {
        try {
            return this.bridge.exists(userReference);
        }
        catch (Exception e) {
            throw new IllegalAccessError("Failed to check if the document [" + String.valueOf(userReference) + "] exists: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void saveEvent(Event event) {
        try {
            this.eventStore.saveEvent(event).get();
        }
        catch (Exception e) {
            this.logger.error("Failed to save the message", (Throwable)e);
        }
    }

    @Override
    public List<Event> getRecentPersonalMessages() {
        return this.getRecentPersonalMessages(this.bridge.getCurrentUserReference(), 30, 0);
    }

    @Override
    public List<Event> getRecentPersonalMessages(int limit, int offset) {
        return this.getRecentPersonalMessages(this.bridge.getCurrentUserReference(), limit, offset);
    }

    @Override
    public List<Event> getRecentPersonalMessages(DocumentReference author) {
        return this.getRecentPersonalMessages(author, 30, 0);
    }

    private SimpleEventQuery createEventQuery(String type, int limit, int offset) {
        SimpleEventQuery query = new SimpleEventQuery(offset >= 0 ? (long)offset : 0L, limit > 0 ? (long)limit : 30L);
        query.eq("application", (Object)type);
        query.eq("type", (Object)"personalMessage");
        query.addSort("date", SortableEventQuery.SortClause.Order.DESC);
        return query;
    }

    @Override
    public List<Event> getRecentPersonalMessages(DocumentReference author, int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            SimpleEventQuery query = this.createEventQuery("personalMessage", limit, offset);
            query.eq("user", (Object)author);
            result = this.eventStore.search((EventQuery)query).stream().collect(Collectors.toList());
        }
        catch (EventStreamException ex) {
            this.logger.warn("Failed to search personal messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public List<Event> getRecentDirectMessages() {
        return this.getRecentDirectMessages(30, 0);
    }

    @Override
    public List<Event> getRecentDirectMessages(int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            SimpleEventQuery query = this.createEventQuery("directMessage", limit, offset);
            query.eq("stream", (Object)this.bridge.getCurrentUserReference());
            result = this.eventStore.search((EventQuery)query).stream().collect(Collectors.toList());
        }
        catch (EventStreamException ex) {
            this.logger.warn("Failed to search direct messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public List<Event> getRecentMessagesForGroup(DocumentReference group) {
        return this.getRecentMessagesForGroup(group, 30, 0);
    }

    @Override
    public List<Event> getRecentMessagesForGroup(DocumentReference group, int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            SimpleEventQuery query = this.createEventQuery("groupMessage", limit, offset);
            query.eq("stream", (Object)group);
            result = this.eventStore.search((EventQuery)query).stream().collect(Collectors.toList());
        }
        catch (EventStreamException ex) {
            this.logger.warn("Failed to search group messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public void deleteMessage(String id) {
        try {
            Optional event = this.eventStore.getEvent(id);
            if (event.isEmpty()) {
                throw new IllegalArgumentException("This message does not exist");
            }
            if (!((Event)event.get()).getUser().equals((Object)this.bridge.getCurrentUserReference())) {
                throw new IllegalArgumentException("You are not authorized to delete this message");
            }
            this.eventStore.deleteEvent((Event)event.get()).get();
        }
        catch (Exception e) {
            this.logger.warn("Failed to delete message: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    protected Event createMessageEvent(String message, String messageType) {
        Event e = this.factory.createEvent();
        e.setApplication(EVENT_APPLICATION);
        e.setDocument(new DocumentReference(this.context.getCurrentEntityReference().getRoot().getName(), "XWiki", e.getId()));
        e.setBody(StringUtils.left((String)message, (int)2000));
        e.setType(messageType);
        return e;
    }
}

