/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailResender;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.MailStatusStore;
import org.xwiki.mail.MailStoreException;
import org.xwiki.mail.SessionFactory;

@Component
@Named(value="database")
@Singleton
public class DatabaseMailResender
implements MailResender {
    private static final String SESSION_BATCHID_KEY = "xwiki.batchId";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="database")
    private Provider<MailListener> databaseMailListenerProvider;
    @Inject
    @Named(value="filesystem")
    private MailContentStore mailContentStore;
    @Inject
    @Named(value="database")
    private MailStatusStore store;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private MailSender mailSender;

    @Override
    public MailStatusResult resendAsynchronously(String batchId, String uniqueMessageId) throws MailStoreException {
        Session session = this.sessionFactory.create(Collections.singletonMap(SESSION_BATCHID_KEY, batchId));
        MimeMessage message = this.loadMessage(session, batchId, uniqueMessageId);
        MailListener databaseMailListener = (MailListener)this.databaseMailListenerProvider.get();
        this.mailSender.sendAsynchronously(Arrays.asList(message), session, databaseMailListener);
        return databaseMailListener.getMailStatusResult();
    }

    @Override
    public List<Pair<MailStatus, MailStatusResult>> resendAsynchronously(Map<String, Object> filterMap, int offset, int count) throws MailStoreException {
        return this.resendGeneric(filterMap, offset, count, (batchId, messageId) -> this.resendAsynchronously(batchId, messageId));
    }

    @Override
    public List<Pair<MailStatus, MailStatusResult>> resend(Map<String, Object> filterMap, int offset, int count) throws MailStoreException {
        return this.resendGeneric(filterMap, offset, count, (batchId, messageId) -> this.resend(batchId, messageId));
    }

    private List<Pair<MailStatus, MailStatusResult>> resendGeneric(Map<String, Object> filterMap, int offset, int count, SingleMailResender singleMailResender) throws MailStoreException {
        ArrayList<Pair<MailStatus, MailStatusResult>> results = new ArrayList<Pair<MailStatus, MailStatusResult>>();
        List<MailStatus> statuses = this.store.load(filterMap, offset, count, null, true);
        for (MailStatus status : statuses) {
            this.resendSingleStatus(status, results, singleMailResender);
        }
        return results;
    }

    private void resendSingleStatus(MailStatus status, List<Pair<MailStatus, MailStatusResult>> results, SingleMailResender singleMailResender) {
        if (!MailState.PREPARE_ERROR.toString().equals(status.getState())) {
            this.logger.debug("Resending mail message [{}]...", (Object)status);
            try {
                results.add((Pair<MailStatus, MailStatusResult>)new ImmutablePair((Object)status, (Object)singleMailResender.resendSingleMessage(status.getBatchId(), status.getMessageId())));
            }
            catch (MailStoreException e) {
                this.logger.warn("Failed to resend mail message for batchId [{}], messageId [{}]. Root cause [{}]", new Object[]{status.getBatchId(), status.getMessageId(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }

    private MimeMessage loadMessage(Session session, String batchId, String mailId) throws MailStoreException {
        ExtendedMimeMessage message = this.mailContentStore.load(session, batchId, mailId);
        return message;
    }

    private MailStatusResult resend(String batchId, String uniqueMessageId) throws MailStoreException {
        MailStatusResult result = this.resendAsynchronously(batchId, uniqueMessageId);
        if (result != null) {
            result.waitTillProcessed(Long.MAX_VALUE);
        }
        return result;
    }

    @FunctionalInterface
    private static interface SingleMailResender {
        public MailStatusResult resendSingleMessage(String var1, String var2) throws MailStoreException;
    }
}

