/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.context.Execution;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.MailStatusStore;
import org.xwiki.mail.MailStorageConfiguration;
import org.xwiki.mail.MailStoreException;
import org.xwiki.mail.internal.AbstractMailListener;
import org.xwiki.mail.internal.DatabaseMailStatusResult;

@Component
@Named(value="database")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DatabaseMailListener
extends AbstractMailListener
implements Initializable {
    @Inject
    private Execution execution;
    @Inject
    @Named(value="filesystem")
    private MailContentStore mailContentStore;
    @Inject
    @Named(value="database")
    private MailStatusStore mailStatusStore;
    @Inject
    private MailStorageConfiguration configuration;
    private DatabaseMailStatusResult mailStatusResult;

    public void initialize() {
        this.mailStatusResult = new DatabaseMailStatusResult(this.mailStatusStore);
    }

    public void onPrepareBegin(String batchId, Map<String, Object> parameters) {
        super.onPrepareBegin(batchId, parameters);
        this.mailStatusResult.setBatchId(batchId);
    }

    public void onPrepareMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        super.onPrepareMessageSuccess(message, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.PREPARE_SUCCESS);
        status.setWiki(((XWikiContext)this.execution.getContext().getProperty("xwikicontext")).getWikiId());
        this.saveStatus(status, parameters);
    }

    public void onPrepareMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        super.onPrepareMessageError(message, exception, parameters);
        MailStatus status = new MailStatus(this.getBatchId(), message, MailState.PREPARE_ERROR);
        status.setWiki(((XWikiContext)this.execution.getContext().getProperty("xwikicontext")).getWikiId());
        status.setError(exception);
        this.saveStatus(status, parameters);
        this.mailStatusResult.incrementCurrentSize();
    }

    public void onPrepareFatalError(Exception exception, Map<String, Object> parameters) {
        super.onPrepareFatalError(exception, parameters);
        this.logger.error("Failure during preparation phase of thread [{}]", (Object)this.getBatchId(), (Object)exception);
    }

    public void onSendMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        super.onSendMessageSuccess(message, parameters);
        String uniqueMessageId = message.getUniqueMessageId();
        MailStatus status = this.retrieveExistingMailStatus(uniqueMessageId, MailState.SEND_SUCCESS);
        if (status != null) {
            status.setState(MailState.SEND_SUCCESS);
        } else {
            this.logger.warn("Forcing a new mail status for message [{}] of batch [{}] to send_success state.", (Object)uniqueMessageId, (Object)this.getBatchId());
            status = new MailStatus(this.getBatchId(), message, MailState.SEND_SUCCESS);
        }
        this.deleteMailContent(status);
        if (this.configuration.discardSuccessStatuses()) {
            this.deleteStatus(status, parameters);
        } else {
            this.saveStatus(status, parameters);
        }
        this.mailStatusResult.incrementCurrentSize();
    }

    public void onSendMessageFatalError(String uniqueMessageId, Exception exception, Map<String, Object> parameters) {
        super.onSendMessageFatalError(uniqueMessageId, exception, parameters);
        MailStatus status = this.retrieveExistingMailStatus(uniqueMessageId, MailState.SEND_FATAL_ERROR);
        if (status != null) {
            status.setState(MailState.SEND_FATAL_ERROR);
            status.setError(exception);
            this.saveStatus(status, parameters);
        } else {
            this.logger.error("Unable to report the fatal error encountered during mail sending for message [{}] of batch [{}].", new Object[]{uniqueMessageId, this.getBatchId(), exception});
        }
        this.mailStatusResult.incrementCurrentSize();
    }

    public void onSendMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        super.onSendMessageError(message, exception, parameters);
        String uniqueMessageId = message.getUniqueMessageId();
        MailStatus status = this.retrieveExistingMailStatus(uniqueMessageId, MailState.SEND_ERROR);
        if (status != null) {
            status.setState(MailState.SEND_ERROR);
        } else {
            this.logger.warn("Forcing a new mail status for message [{}] of batch [{}] to send_error state.", (Object)uniqueMessageId, (Object)this.getBatchId());
            status = new MailStatus(this.getBatchId(), message, MailState.SEND_ERROR);
        }
        status.setError(exception);
        this.saveStatus(status, parameters);
        this.mailStatusResult.incrementCurrentSize();
    }

    private MailStatus retrieveExistingMailStatus(String uniqueMessageId, MailState state) {
        MailStatus status;
        try {
            status = this.mailStatusStore.load(uniqueMessageId);
            if (status == null) {
                this.logger.error("Failed to find a previous mail status for message [{}] of batch [{}] and state [{}].", new Object[]{uniqueMessageId, this.getBatchId(), state});
            }
        }
        catch (MailStoreException e) {
            this.logger.error("Error when looking for a previous mail status for message [{}] of batch [{}] and state [{}].", new Object[]{uniqueMessageId, this.getBatchId(), state, e});
            status = null;
        }
        return status;
    }

    public MailStatusResult getMailStatusResult() {
        return this.mailStatusResult;
    }

    private void saveStatus(MailStatus status, Map<String, Object> parameters) {
        try {
            this.mailStatusStore.save(status, parameters);
        }
        catch (MailStoreException e) {
            this.logger.error("Failed to save mail status [{}] to the database", (Object)status, (Object)e);
        }
    }

    private void deleteStatus(MailStatus status, Map<String, Object> parameters) {
        try {
            this.mailStatusStore.delete(status.getMessageId(), parameters);
        }
        catch (MailStoreException e) {
            this.logger.error("Failed to delete mail status [{}] from the database", (Object)status, (Object)e);
        }
    }

    private void deleteMailContent(MailStatus currentStatus) {
        if (currentStatus != null) {
            try {
                this.mailContentStore.delete(currentStatus.getBatchId(), currentStatus.getMessageId());
            }
            catch (MailStoreException e) {
                this.logger.warn("Failed to remove previously failing message [{}] (batch id [{}]) from the file system. Reason [{}].", new Object[]{currentStatus.getMessageId(), currentStatus.getBatchId(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }
}

