/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.users;

import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.factory.AbstractMessageIterator;
import org.xwiki.model.reference.DocumentReference;

@Deprecated
public class UsersMimeMessageIterator
extends AbstractMessageIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersMimeMessageIterator.class);
    private DocumentAccessBridge documentAccessBridge;
    private final List<DocumentReference> users;
    private ComponentManager componentManager;

    public UsersMimeMessageIterator(List<DocumentReference> userReferences, MimeMessageFactory<MimeMessage> factory, Map<String, Object> parameters, ComponentManager componentManager) throws MessagingException {
        this.factory = factory;
        this.parameters = parameters;
        this.iteratorSize = userReferences.size();
        this.users = userReferences;
        this.componentManager = componentManager;
        this.documentAccessBridge = this.getAccessBridge();
    }

    private DocumentAccessBridge getAccessBridge() throws MessagingException {
        DocumentAccessBridge accessBridge;
        try {
            accessBridge = (DocumentAccessBridge)this.componentManager.getInstance(DocumentAccessBridge.class);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException("Failed to find default Document bridge ", (Exception)((Object)e));
        }
        return accessBridge;
    }

    protected ExtendedMimeMessage createMessageInternal() throws MessagingException {
        ExtendedMimeMessage mimeMessage;
        DocumentReference userReference = this.users.get(this.position);
        Object emailObject = this.documentAccessBridge.getProperty(userReference, new DocumentReference(userReference.getWikiReference().getName(), "XWiki", "XWikiUsers"), "email");
        if (emailObject != null) {
            String email = emailObject.toString();
            Map parameters = (Map)this.parameters.get("parameters");
            mimeMessage = ExtendedMimeMessage.wrap((MimeMessage)((MimeMessage)this.factory.createMessage(this.parameters.get("source"), parameters)));
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)InternetAddress.parse((String)email)[0]);
        } else {
            this.getLogger().warn("User [{}] has no email defined. Email has not been sent to that user.", (Object)userReference);
            mimeMessage = null;
        }
        return mimeMessage;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

