/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.instance.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.instance.InstanceId;
import org.xwiki.instance.InstanceIdManager;
import org.xwiki.instance.internal.DefaultInstanceIdManagerAspect;

@Component
@Singleton
public class DefaultInstanceIdManager
implements InstanceIdManager,
Initializable {
    @Inject
    @Named(value="hibernate")
    private Provider<XWikiStoreInterface> hibernateStoreProvider;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private InstanceId instanceId;

    @Override
    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        XWikiContext context = this.getXWikiContext();
        XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStoreProvider.get();
        String originalDatabase = context.getWikiId();
        context.setWikiId(context.getMainXWiki());
        try {
            InstanceId id = (InstanceId)store.failSafeExecuteRead(context, session -> {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery query = builder.createQuery(InstanceId.class);
                Root root = query.from(InstanceId.class);
                query.select((Selection)root);
                return (InstanceId)session.createQuery(query).getSingleResult();
            });
            if (id == null) {
                InstanceId newId = new InstanceId(UUID.randomUUID().toString());
                try {
                    store.executeWrite(context, session -> {
                        session.createQuery("delete from " + InstanceId.class.getName()).executeUpdate();
                        session.save((Object)newId);
                        return null;
                    });
                }
                catch (XWikiException e) {
                    this.logger.warn("Failed to save Instance id to database. Reason: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                id = newId;
            }
            this.instanceId = id;
        }
        finally {
            context.setWikiId(originalDatabase);
        }
    }

    private XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    public static /* synthetic */ InstanceId ajc$get$instanceId(DefaultInstanceIdManager defaultInstanceIdManager) {
        return defaultInstanceIdManager.instanceId;
    }

    public static /* synthetic */ void ajc$set$instanceId(DefaultInstanceIdManager defaultInstanceIdManager, InstanceId instanceId) {
        defaultInstanceIdManager.instanceId = instanceId;
    }

    @Override
    @Deprecated
    public void initializeInstanceId() {
        DefaultInstanceIdManagerAspect.ajc$interMethod$org_xwiki_instance_internal_DefaultInstanceIdManagerAspect$org_xwiki_instance_internal_DefaultInstanceIdManager$initializeInstanceId(this);
    }
}

