/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.repository;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.internal.installed.AbstractInstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentVersionReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarEntryType;
import org.xwiki.xar.XarEntryTypeResolver;
import org.xwiki.xar.XarException;

@Component
@Singleton
@Named(value="xar")
public class XarInstalledExtensionRepository
extends AbstractInstalledExtensionRepository<XarInstalledExtension>
implements Initializable {
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient XarEntryTypeResolver typeResolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    private Map<DocumentReference, Collection<XarInstalledExtension>> documents = new ConcurrentHashMap<DocumentReference, Collection<XarInstalledExtension>>();
    private Map<LocalDocumentReference, Collection<XarInstalledExtension>> rootDocuments = new ConcurrentHashMap<LocalDocumentReference, Collection<XarInstalledExtension>>();

    public void initialize() throws InitializationException {
        this.setDescriptor((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("xar", "xar", this.installedRepository.getDescriptor().getURI()));
        this.loadExtensions();
    }

    void pagesRemoved(ExtensionId extensionId, String namespace) throws UnsupportedNamespaceException {
        this.pagesUpdated(extensionId, namespace, false);
    }

    void pagesAdded(ExtensionId extensionId, String namespace) throws UnsupportedNamespaceException {
        this.pagesUpdated(extensionId, namespace, true);
    }

    private void pagesUpdated(ExtensionId extensionId, String namespace, boolean add) throws UnsupportedNamespaceException {
        XarInstalledExtension installedExtension = (XarInstalledExtension)this.getInstalledExtension(extensionId);
        this.pagesUpdated(installedExtension, namespace, add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pagesUpdated(XarInstalledExtension installedExtension, String namespace, boolean add) throws UnsupportedNamespaceException {
        if (installedExtension != null) {
            for (XarEntry xarEntry : installedExtension.getXarPackage().getEntries()) {
                if (namespace != null) {
                    DocumentReference reference = new DocumentReference((LocalDocumentReference)xarEntry, new WikiReference(XarHandlerUtils.getWikiFromNamespace(namespace)));
                    Map<DocumentReference, Collection<XarInstalledExtension>> map = this.documents;
                    synchronized (map) {
                        Collection<XarInstalledExtension> referenceExtensions = this.documents.get(reference);
                        if (referenceExtensions != null || add) {
                            LinkedHashSet<XarInstalledExtension> newSet;
                            LinkedHashSet<XarInstalledExtension> linkedHashSet = newSet = referenceExtensions != null ? new LinkedHashSet<XarInstalledExtension>(referenceExtensions) : new LinkedHashSet();
                            if (add) {
                                newSet.add(installedExtension);
                            } else {
                                newSet.remove((Object)installedExtension);
                            }
                            this.documents.put((DocumentReference)this.referenceFactory.getReference((EntityReference)reference), newSet);
                        }
                        continue;
                    }
                }
                Map<LocalDocumentReference, Collection<XarInstalledExtension>> map = this.rootDocuments;
                synchronized (map) {
                    Collection<XarInstalledExtension> referenceExtensions = this.rootDocuments.get(xarEntry);
                    if (referenceExtensions != null || add) {
                        LinkedHashSet<XarInstalledExtension> newSet;
                        LinkedHashSet<XarInstalledExtension> linkedHashSet = newSet = referenceExtensions != null ? new LinkedHashSet<XarInstalledExtension>(referenceExtensions) : new LinkedHashSet();
                        if (add) {
                            newSet.add(installedExtension);
                        } else {
                            newSet.remove((Object)installedExtension);
                        }
                        this.rootDocuments.put((LocalDocumentReference)xarEntry, newSet);
                    }
                }
            }
        }
    }

    void updateCachedXarExtension(ExtensionId extensionId) {
        InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(extensionId);
        if (installedExtension != null && "xar".equals(installedExtension.getType())) {
            if (this.getInstalledExtension(installedExtension.getId()) == null) {
                try {
                    this.addCacheXarExtension(installedExtension);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse extension [{}]", (Object)installedExtension.getId(), (Object)e);
                }
            }
        } else {
            this.removeCachedXarExtension(extensionId);
        }
    }

    private XarInstalledExtension addCacheXarExtension(InstalledExtension installedExtension) throws IOException, XarException {
        XarInstalledExtension xarExtension = new XarInstalledExtension(installedExtension, this);
        this.addCachedExtension((Extension)xarExtension);
        return xarExtension;
    }

    protected void removeCachedXarExtension(ExtensionId extensionId) {
        XarInstalledExtension extension = (XarInstalledExtension)this.getInstalledExtension(extensionId);
        if (extension != null) {
            super.removeCachedExtension((Extension)extension);
        }
    }

    private void loadExtensions() {
        for (InstalledExtension localExtension : this.installedRepository.getInstalledExtensions()) {
            if (!"xar".equalsIgnoreCase(localExtension.getType())) continue;
            try {
                XarInstalledExtension xarInstalledExtension = this.addCacheXarExtension(localExtension);
                if (xarInstalledExtension.getNamespaces() == null) {
                    this.pagesUpdated(xarInstalledExtension, null, true);
                    continue;
                }
                for (String namespace : localExtension.getNamespaces()) {
                    this.pagesUpdated(xarInstalledExtension, namespace, true);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to parse extension [{}]", (Object)localExtension.getId(), (Object)e);
            }
        }
    }

    public Collection<XarInstalledExtension> getXarInstalledExtensions(DocumentReference reference) {
        ExtensionId extensionId;
        DocumentVersionReference versionReference;
        Serializable serializable;
        if (reference instanceof DocumentVersionReference && (serializable = (versionReference = (DocumentVersionReference)reference).getVersion()) instanceof ExtensionId && (extensionId = (ExtensionId)serializable) != null) {
            return Arrays.asList((XarInstalledExtension)this.getInstalledExtension(extensionId));
        }
        Collection<XarInstalledExtension> wikiExtensions = this.documents.get(reference.getLocale() == null ? new DocumentReference((EntityReference)reference, Locale.ROOT) : reference);
        Collection<XarInstalledExtension> rootExtensions = this.rootDocuments.get(reference.getLocalDocumentReference().getLocale() == null ? new LocalDocumentReference((EntityReference)reference.getLocalDocumentReference(), Locale.ROOT) : reference.getLocalDocumentReference());
        ArrayList<XarInstalledExtension> allExtensions = new ArrayList<XarInstalledExtension>();
        if (wikiExtensions != null) {
            allExtensions.addAll(wikiExtensions);
        }
        if (rootExtensions != null) {
            allExtensions.addAll(rootExtensions);
        }
        return allExtensions;
    }

    public boolean isAllowed(DocumentReference documentReference, Right right) {
        Collection<XarInstalledExtension> extensions = this.getXarInstalledExtensions(documentReference);
        LocalDocumentReference localDocumentReference = documentReference.getLocalDocumentReference();
        if (localDocumentReference.getLocale() == null) {
            localDocumentReference = new LocalDocumentReference((EntityReference)localDocumentReference, Locale.ROOT);
        }
        for (XarInstalledExtension extension : extensions) {
            XarEntry entry = extension.getXarPackage().getEntry(localDocumentReference);
            XarEntryType type = this.typeResolver.resolve(entry, true);
            boolean allowed = Right.EDIT.equals(right) ? type.isEditAllowed() : (Right.DELETE.equals(right) ? type.isDeleteAllowed() : true);
            if (allowed) continue;
            return false;
        }
        return true;
    }

    public InstalledExtension getInstalledExtension(String id, String namespace) {
        Object extension = this.installedRepository.getInstalledExtension(id, namespace);
        if (extension != null) {
            extension = "xar".equals(extension.getType()) ? (InstalledExtension)this.extensions.get(extension.getId()) : null;
        }
        return extension;
    }

    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency, Map<String, Object> properties) throws InstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<InstalledExtension> getBackwardDependencies(String id, String namespace, boolean withOptional) throws ResolveException {
        InstalledExtension extension = this.installedRepository.getInstalledExtension(id, namespace);
        return "xar".equals(extension.getType()) ? this.installedRepository.getBackwardDependencies(id, namespace, withOptional) : null;
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId, boolean withOptional) throws ResolveException {
        InstalledExtension extension = this.installedRepository.resolve(extensionId);
        return "xar".equals(extension.getType()) ? this.installedRepository.getBackwardDependencies(extensionId) : null;
    }
}

