/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job.diff;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.extension.xar.internal.job.diff.AbstractUnifiedDiffBuilder;
import org.xwiki.extension.xar.internal.job.diff.AttachmentUnifiedDiffBuilder;
import org.xwiki.extension.xar.job.diff.DocumentUnifiedDiff;
import org.xwiki.extension.xar.job.diff.EntityUnifiedDiff;
import org.xwiki.mail.GeneralMailConfiguration;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentVersionReference;
import org.xwiki.model.reference.ObjectReference;

@Component(roles={DocumentUnifiedDiffBuilder.class})
@Singleton
public class DocumentUnifiedDiffBuilder
extends AbstractUnifiedDiffBuilder {
    private static final DocumentReference EMPTY_DOCUMENT_REFERENCE = new DocumentReference("wiki", "Space", "EmptyDocument");
    @Inject
    private AttachmentUnifiedDiffBuilder attachmentDiffBuilder;
    @Inject
    private Provider<GeneralMailConfiguration> emailProvider;

    public DocumentUnifiedDiff diff(XWikiDocument previousDocument, XWikiDocument nextDocument) {
        DocumentUnifiedDiff diff = new DocumentUnifiedDiff(this.getDocumentVersionReference(previousDocument), this.getDocumentVersionReference(nextDocument));
        if (previousDocument != nextDocument) {
            XWikiDocument nonNullPreviousDocument = this.emptyDocumentIfNull(previousDocument);
            XWikiDocument nonNullNextDocument = this.emptyDocumentIfNull(nextDocument);
            this.addDocumentFieldDiffs(nonNullPreviousDocument, nonNullNextDocument, diff);
            this.addAttachmentDiffs(nonNullPreviousDocument, nonNullNextDocument, diff);
            this.addObjectDiffs(nonNullPreviousDocument, nonNullNextDocument, diff);
            this.addClassPropertyDiffs(nonNullPreviousDocument.getXClass(), nonNullNextDocument.getXClass(), diff);
        }
        return diff;
    }

    private DocumentVersionReference getDocumentVersionReference(XWikiDocument document) {
        if (document == null) {
            return null;
        }
        DocumentVersionReference documentVersionReference = new DocumentVersionReference(document.getDocumentReferenceWithLocale());
        if (documentVersionReference.getVersion() == null) {
            return new DocumentVersionReference((DocumentReference)documentVersionReference, (Serializable)((Object)document.getVersion()));
        }
        return documentVersionReference;
    }

    private XWikiDocument emptyDocumentIfNull(XWikiDocument document) {
        if (document == null) {
            XWikiDocument emptyDocument = new XWikiDocument(EMPTY_DOCUMENT_REFERENCE);
            emptyDocument.setSyntax(null);
            return emptyDocument;
        }
        return document;
    }

    private boolean isNull(XWikiDocument document) {
        return document.getDocumentReference() == EMPTY_DOCUMENT_REFERENCE;
    }

    private void addDocumentFieldDiffs(XWikiDocument previousDocument, XWikiDocument nextDocument, DocumentUnifiedDiff documentDiff) {
        this.maybeAddDiff(documentDiff, "title", previousDocument.getTitle(), nextDocument.getTitle());
        this.maybeAddDiff(documentDiff, "parent", previousDocument.getParentReference(), nextDocument.getParentReference());
        this.maybeAddDiff(documentDiff, "hidden", this.isNull(previousDocument) ? null : previousDocument.isHidden(), this.isNull(nextDocument) ? null : nextDocument.isHidden());
        this.maybeAddDiff(documentDiff, "defaultLocale", previousDocument.getDefaultLocale(), nextDocument.getDefaultLocale());
        this.maybeAddDiff(documentDiff, "syntax", previousDocument.getSyntax(), nextDocument.getSyntax());
        this.maybeAddDiff(documentDiff, "content", previousDocument.getContent(), nextDocument.getContent());
    }

    private void addAttachmentDiffs(XWikiDocument previousDocument, XWikiDocument nextDocument, DocumentUnifiedDiff documentDiff) {
        for (XWikiAttachment previousAttachment : previousDocument.getAttachmentList()) {
            XWikiAttachment nextAttachment;
            if (previousAttachment == (nextAttachment = nextDocument.getAttachment(previousAttachment.getFilename()))) continue;
            this.attachmentDiffBuilder.addAttachmentDiff(previousAttachment, nextAttachment, documentDiff);
        }
        for (XWikiAttachment nextAttachment : nextDocument.getAttachmentList()) {
            XWikiAttachment previousAttachment = previousDocument.getAttachment(nextAttachment.getFilename());
            if (previousAttachment != null) continue;
            this.attachmentDiffBuilder.addAttachmentDiff(previousAttachment, nextAttachment, documentDiff);
        }
    }

    private void addObjectDiffs(XWikiDocument previousDocument, XWikiDocument nextDocument, DocumentUnifiedDiff documentDiff) {
        for (List previousObjects : previousDocument.getXObjects().values()) {
            for (BaseObject previousObject : previousObjects) {
                BaseObject nextObject;
                if (previousObject == null || previousObject == (nextObject = nextDocument.getXObject(previousObject.getXClassReference(), previousObject.getNumber()))) continue;
                this.addObjectDiff(previousObject, nextObject, documentDiff);
            }
        }
        for (List nextObjects : nextDocument.getXObjects().values()) {
            for (BaseObject nextObject : nextObjects) {
                BaseObject previousObject;
                if (nextObject == null || (previousObject = previousDocument.getXObject(nextObject.getXClassReference(), nextObject.getNumber())) != null) continue;
                this.addObjectDiff(previousObject, nextObject, documentDiff);
            }
        }
    }

    private void addObjectDiff(BaseObject previousObject, BaseObject nextObject, DocumentUnifiedDiff documentDiff) {
        ObjectReference previousReference = this.getObjectVersionReference(previousObject, (DocumentVersionReference)documentDiff.getPreviousReference());
        ObjectReference nextReference = this.getObjectVersionReference(nextObject, (DocumentVersionReference)documentDiff.getNextReference());
        EntityUnifiedDiff<ObjectReference> objectDiff = new EntityUnifiedDiff<ObjectReference>(previousReference, nextReference);
        this.addObjectDiff((BaseCollection<?>)(previousObject == null ? new BaseObject() : previousObject), (BaseCollection<?>)(nextObject == null ? new BaseObject() : nextObject), objectDiff);
        if (objectDiff.size() > 0) {
            documentDiff.getObjectDiffs().add(objectDiff);
        }
    }

    private ObjectReference getObjectVersionReference(BaseObject object, DocumentVersionReference documentVersionReference) {
        return object == null ? null : new BaseObjectReference(object.getXClassReference(), Integer.valueOf(object.getNumber()), (DocumentReference)documentVersionReference);
    }

    private void addObjectDiff(BaseCollection<?> previousObject, BaseCollection<?> nextObject, Map<String, List<UnifiedDiffBlock<String, Character>>> objectDiff) {
        BaseProperty nextProperty;
        BaseProperty previousProperty;
        for (String propertyName : previousObject.getPropertyList()) {
            previousProperty = (BaseProperty)previousObject.getField(propertyName);
            if (previousProperty == (nextProperty = (BaseProperty)nextObject.getField(propertyName))) continue;
            this.addObjectPropertyDiff(previousProperty, nextProperty, objectDiff);
        }
        for (String propertyName : nextObject.getPropertyList()) {
            previousProperty = (BaseProperty)previousObject.getField(propertyName);
            nextProperty = (BaseProperty)nextObject.getField(propertyName);
            if (previousProperty != null) continue;
            this.addObjectPropertyDiff(previousProperty, nextProperty, objectDiff);
        }
    }

    private void addObjectPropertyDiff(BaseProperty<?> previousProperty, BaseProperty<?> nextProperty, Map<String, List<UnifiedDiffBlock<String, Character>>> objectDiff) {
        Object nextValue;
        String key = previousProperty == null ? nextProperty.getName() : previousProperty.getName();
        Object previousValue = previousProperty == null ? null : previousProperty.getValue();
        Object object = nextValue = nextProperty == null ? null : nextProperty.getValue();
        if (this.maybeAddDiff(objectDiff, key, previousValue, nextValue) && (this.isPrivateProperty(previousProperty) || this.isPrivateProperty(nextProperty))) {
            objectDiff.get(key).clear();
        }
    }

    private boolean isPrivateProperty(BaseProperty<?> property) {
        BaseClass xclass;
        BaseCollection object;
        BaseCollection baseCollection = object = property == null ? null : property.getObject();
        if (object != null && (xclass = object.getXClass((XWikiContext)this.xcontextProvider.get())) != null) {
            PropertyClass propertyClass = (PropertyClass)xclass.get(property.getName());
            String propertyType = propertyClass == null ? null : propertyClass.getClassType();
            return "Password".equals(propertyType) || "Email".equals(propertyType) && ((GeneralMailConfiguration)this.emailProvider.get()).shouldObfuscate();
        }
        return false;
    }

    private void addClassPropertyDiffs(BaseClass previousClass, BaseClass nextClass, DocumentUnifiedDiff documentDiff) {
        PropertyClass nextProperty;
        PropertyClass previousProperty;
        for (String propertyName : previousClass.getPropertyList()) {
            previousProperty = (PropertyClass)previousClass.get(propertyName);
            nextProperty = (PropertyClass)nextClass.get(propertyName);
            this.addClassPropertyDiff(previousProperty, nextProperty, documentDiff);
        }
        for (String propertyName : nextClass.getPropertyList()) {
            previousProperty = (PropertyClass)previousClass.get(propertyName);
            nextProperty = (PropertyClass)nextClass.get(propertyName);
            if (previousProperty != null) continue;
            this.addClassPropertyDiff(previousProperty, nextProperty, documentDiff);
        }
    }

    private void addClassPropertyDiff(PropertyClass previousProperty, PropertyClass nextProperty, DocumentUnifiedDiff documentDiff) {
        ClassPropertyReference previousReference = this.getClassPropertyVersionReference(previousProperty, (DocumentVersionReference)documentDiff.getPreviousReference());
        ClassPropertyReference nextReference = this.getClassPropertyVersionReference(nextProperty, (DocumentVersionReference)documentDiff.getNextReference());
        EntityUnifiedDiff<ClassPropertyReference> classPropertyDiff = new EntityUnifiedDiff<ClassPropertyReference>(previousReference, nextReference);
        this.maybeAddDiff(classPropertyDiff, "type", previousProperty == null ? null : previousProperty.getClassType(), nextProperty == null ? null : nextProperty.getClassType());
        this.addObjectDiff((BaseCollection<?>)(previousProperty == null ? new PropertyClass() : previousProperty), (BaseCollection<?>)(nextProperty == null ? new PropertyClass() : nextProperty), classPropertyDiff);
        classPropertyDiff.remove("name");
        classPropertyDiff.remove("unmodifiable");
        if (classPropertyDiff.size() > 0) {
            documentDiff.getClassPropertyDiffs().add(classPropertyDiff);
        }
    }

    private ClassPropertyReference getClassPropertyVersionReference(PropertyClass property, DocumentVersionReference documentVersionReference) {
        return property == null ? null : new ClassPropertyReference(property.getName(), (DocumentReference)documentVersionReference);
    }
}

