/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job.diff;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.xar.internal.job.diff.AbstractUnifiedDiffBuilder;
import org.xwiki.extension.xar.job.diff.DocumentUnifiedDiff;
import org.xwiki.extension.xar.job.diff.EntityUnifiedDiff;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentVersionReference;

@Component(roles={AttachmentUnifiedDiffBuilder.class})
@Singleton
public class AttachmentUnifiedDiffBuilder
extends AbstractUnifiedDiffBuilder {
    private static final List<String> TEXT_MEDIA_TYPE_PATTERNS = Arrays.asList("text/", "application/xml", "application/javascript", "application/ecmascript", "application/json", "application/x-sh", "+xml");
    private static final long TEXT_FILE_SIZE_LIMIT = 50000L;

    public void addAttachmentDiff(XWikiAttachment previousAttachment, XWikiAttachment nextAttachment, DocumentUnifiedDiff documentDiff) {
        AttachmentReference previousReference = this.getAttachmentVersionReference(previousAttachment, (DocumentVersionReference)documentDiff.getPreviousReference());
        AttachmentReference nextReference = this.getAttachmentVersionReference(nextAttachment, (DocumentVersionReference)documentDiff.getNextReference());
        EntityUnifiedDiff<AttachmentReference> attachmentDiff = new EntityUnifiedDiff<AttachmentReference>(previousReference, nextReference);
        if ((previousAttachment == null || this.isSmallTextFile(previousAttachment)) && (nextAttachment == null || this.isSmallTextFile(nextAttachment))) {
            this.maybeAddDiff(attachmentDiff, "content", this.getContentAsString(previousAttachment), this.getContentAsString(nextAttachment));
        } else {
            this.maybeAddDiff(attachmentDiff, "size", previousAttachment == null ? null : Long.valueOf(previousAttachment.getLongSize()), nextAttachment == null ? null : Long.valueOf(nextAttachment.getLongSize()));
            if (attachmentDiff.isEmpty() && !this.contentEquals(previousAttachment, nextAttachment)) {
                attachmentDiff.put("content", Collections.emptyList());
            }
        }
        if (attachmentDiff.size() > 0) {
            documentDiff.getAttachmentDiffs().add(attachmentDiff);
        }
    }

    private AttachmentReference getAttachmentVersionReference(XWikiAttachment attachment, DocumentVersionReference documentVersionReference) {
        return attachment == null ? null : new AttachmentReference(attachment.getFilename(), (DocumentReference)documentVersionReference);
    }

    private boolean isSmallTextFile(XWikiAttachment attachment) {
        if (attachment != null && attachment.getLongSize() < 50000L) {
            String mediaType = attachment.getMimeType((XWikiContext)this.xcontextProvider.get());
            for (String mediaTypePattern : TEXT_MEDIA_TYPE_PATTERNS) {
                if (!mediaType.equals(mediaTypePattern) && !mediaType.startsWith(mediaTypePattern) && !mediaType.endsWith(mediaTypePattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contentEquals(XWikiAttachment previousAttachment, XWikiAttachment nextAttachment) {
        if (previousAttachment == null || nextAttachment == null) {
            return previousAttachment == nextAttachment;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        InputStream previousContent = null;
        InputStream nextContent = null;
        try {
            previousContent = previousAttachment.getContentInputStream(xcontext);
            nextContent = nextAttachment.getContentInputStream(xcontext);
            boolean bl = IOUtils.contentEquals((InputStream)previousContent, (InputStream)nextContent);
            return bl;
        }
        catch (Exception e) {
            this.logger.warn("Failed to compare the content of attachment [{}]. Root cause: {}", (Object)previousAttachment.getFilename(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (previousContent != null) {
                    previousContent.close();
                }
                if (nextContent != null) {
                    nextContent.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getContentAsString(XWikiAttachment attachment) {
        try {
            return attachment == null ? null : IOUtils.toString((InputStream)attachment.getContentInputStream((XWikiContext)this.xcontextProvider.get()));
        }
        catch (Exception e) {
            this.logger.warn("Failed to read the content of attachment [{}]. Root cause: {}", (Object)attachment.getFilename(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

