/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.job.diff.DocumentUnifiedDiffBuilder;
import org.xwiki.extension.xar.job.diff.DiffXarJobStatus;
import org.xwiki.extension.xar.job.diff.DocumentUnifiedDiff;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentVersionReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.XarFile;

@Component
@Named(value="diffXar")
public class DiffXarJob
extends AbstractExtensionJob<InstallRequest, DiffXarJobStatus> {
    public static final String JOB_TYPE = "diffXar";
    @Inject
    private Packager packager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentUnifiedDiffBuilder documentDiffBuilder;
    private Set<String> comparedFeatures = new HashSet<String>();

    public String getType() {
        return JOB_TYPE;
    }

    protected DiffXarJobStatus createNewStatus(InstallRequest request) {
        return new DiffXarJobStatus(request, this.observationManager, this.loggerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        InstallRequest request = (InstallRequest)this.getRequest();
        if (!request.hasNamespaces() || request.getNamespaces().size() != 1) {
            return;
        }
        String namespace = (String)request.getNamespaces().iterator().next();
        Collection extensionIds = request.getExtensions();
        this.progressManager.pushLevelProgress(extensionIds.size(), (Object)this);
        try {
            for (ExtensionId extensionId : extensionIds) {
                this.progressManager.startStep((Object)this);
                InstalledExtension installedExtension = this.getInstalledExtension(extensionId, namespace);
                if (installedExtension != null && installedExtension.isInstalled(namespace)) {
                    this.diff(extensionId.getId(), namespace, new HashSet<LocalDocumentReference>());
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private InstalledExtension getInstalledExtension(ExtensionId extensionId, String namespace) {
        if (extensionId.getVersion() != null) {
            return this.installedExtensionRepository.getInstalledExtension(extensionId);
        }
        return this.installedExtensionRepository.getInstalledExtension(extensionId.getId(), namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diff(String feature, String namespace, Set<LocalDocumentReference> alreadydone) {
        if (this.comparedFeatures.contains(feature)) {
            return;
        }
        this.comparedFeatures.add(feature);
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(feature, namespace);
        if (installedExtension != null) {
            this.diff(installedExtension, namespace, alreadydone);
            Collection dependencies = installedExtension.getDependencies();
            this.progressManager.pushLevelProgress(dependencies.size(), (Object)this);
            try {
                for (ExtensionDependency dependency : dependencies) {
                    this.progressManager.startStep((Object)this);
                    this.diff(dependency.getId(), namespace, new HashSet<LocalDocumentReference>(alreadydone));
                }
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        }
    }

    private void diff(InstalledExtension installedExtension, String namespace, Set<LocalDocumentReference> alreadydone) {
        Collection excludedExtensions = ((InstallRequest)this.getRequest()).getExcludedExtensions();
        if ("xar".equals(installedExtension.getType()) && (excludedExtensions == null || !excludedExtensions.contains(installedExtension.getId()))) {
            if (((InstallRequest)this.getRequest()).isVerbose()) {
                this.logger.info("Computing differences for [{}] on namespace [{}]", (Object)installedExtension.getId(), (Object)namespace);
            }
            try {
                WikiReference wikiReference = new WikiReference(XarHandlerUtils.getWikiFromNamespace(namespace));
                this.diff(new XarFile(new File(installedExtension.getFile().getAbsolutePath())), wikiReference, installedExtension.getId(), alreadydone);
            }
            catch (UnsupportedNamespaceException e) {
                this.logger.error("Failed to extract the wiki id from the namespace [{}].", (Object)namespace, (Object)e);
            }
            catch (IOException e) {
                this.logger.error("Failed to read the XAR file of the extension [{}].", (Object)installedExtension.getId(), (Object)e);
            }
            catch (XarException e) {
                this.logger.error("Failed to parse the XAR file of the extension [{}].", (Object)installedExtension.getId(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diff(XarFile xarFile, WikiReference wikiReference, ExtensionId extensionId, Set<LocalDocumentReference> alreadydone) {
        Collection xarEntries = xarFile.getEntries();
        this.progressManager.pushLevelProgress(xarEntries.size(), (Object)this);
        try {
            for (XarEntry xarEntry : xarEntries) {
                this.progressManager.startStep((Object)this);
                if (alreadydone.contains(xarEntry)) continue;
                try {
                    this.diff(this.packager.getXWikiDocument(xarFile.getInputStream((LocalDocumentReference)xarEntry), wikiReference), extensionId);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse document [{}] from XAR.", (Object)xarEntry.getDocumentName(), (Object)e);
                }
                alreadydone.add((LocalDocumentReference)xarEntry);
            }
        }
        finally {
            try {
                xarFile.close();
            }
            catch (IOException iOException) {}
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void diff(XWikiDocument document, ExtensionId extensionId) {
        if (((InstallRequest)this.getRequest()).isVerbose()) {
            this.logger.info("Computing differences for document [{}]", (Object)document.getDocumentReferenceWithLocale());
        }
        XWikiDocument previousDocument = document.duplicate((DocumentReference)new DocumentVersionReference(document.getDocumentReference(), (Serializable)extensionId));
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument nextDocument = xcontext.getWiki().getDocument(document.getDocumentReferenceWithLocale(), xcontext);
            if (nextDocument.isNew()) {
                nextDocument = null;
            }
            this.maybeAddDocumentDiff(this.documentDiffBuilder.diff(previousDocument, nextDocument));
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get document [{}] from the database.", (Object)document.getDocumentReference(), (Object)e);
        }
    }

    private void maybeAddDocumentDiff(DocumentUnifiedDiff documentDiff) {
        int differencesCount = documentDiff.size() + documentDiff.getAttachmentDiffs().size() + documentDiff.getObjectDiffs().size() + documentDiff.getClassPropertyDiffs().size();
        if (((InstallRequest)this.getRequest()).isVerbose()) {
            if (documentDiff.getNextReference() == null) {
                this.logger.info("The document [{}] has been deleted", documentDiff.getPreviousReference());
            } else if (documentDiff.getPreviousReference() == null) {
                this.logger.info("The document [{}] has been added", documentDiff.getNextReference());
            } else if (differencesCount > 0) {
                this.logger.info("The document [{}] has [{}] changes", documentDiff.getPreviousReference(), (Object)differencesCount);
            } else {
                this.logger.info("The document [{}] has no changes", documentDiff.getPreviousReference());
            }
        }
        if (differencesCount > 0) {
            ((DiffXarJobStatus)this.getStatus()).getDocumentDiffs().add(documentDiff);
        }
    }
}

