/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionContext;
import org.xwiki.extension.ExtensionSession;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.DeletedXarExtensionPages;
import org.xwiki.extension.xar.internal.handler.DeletingXarExtensionPages;
import org.xwiki.extension.xar.internal.handler.XarExtensionHandler;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlanEntry;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.question.CleanPagesQuestion;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishingEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.xar.XarEntry;

@Component
@Singleton
@Named(value="XarExtensionJobFinishedListener")
public class XarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new JobFinishingEvent("install"), new JobFinishingEvent("uninstall"));
    @Inject
    private ExtensionContext extensionContext;
    @Inject
    private Provider<Packager> packagerProvider;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private WikiDescriptorManager wikiManager;
    @Inject
    private SecurityCache security;
    @Inject
    private SecurityReferenceFactory securityFactory;
    @Inject
    private ObservationManager observation;

    public String getName() {
        return "XarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XarExtensionPlan xarExtensionPlan;
        Optional extensionSession;
        JobFinishingEvent jobFinishingEvent = (JobFinishingEvent)event;
        if (!jobFinishingEvent.getRequest().isRemote() && (extensionSession = this.extensionContext.getExtensionSession()).isPresent() && (xarExtensionPlan = (XarExtensionPlan)((ExtensionSession)extensionSession.get()).get("extension.xar.installplan")) != null) {
            Map<Object, Object> rootNextPages;
            Map<String, Map<XarEntry, XarExtensionPlanEntry>> previousXAREntries = xarExtensionPlan.previousXAREntries;
            Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = xarExtensionPlan.nextXAREntries;
            Map<Object, XarExtensionPlanEntry> rootPreviousPages = previousXAREntries.get(null);
            if (rootPreviousPages == null) {
                rootPreviousPages = Collections.emptyMap();
            }
            if ((rootNextPages = nextXAREntries.get(null)) == null) {
                rootNextPages = Collections.emptyMap();
            }
            this.maybeDeletePages(jobFinishingEvent, xarExtensionPlan, previousXAREntries, (Job)source);
            this.invalidateSecurityCache(previousXAREntries, rootPreviousPages, nextXAREntries, rootNextPages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDeletePages(JobFinishingEvent jobFinishingEvent, XarExtensionPlan xarExtensionPlan, Map<String, Map<XarEntry, XarExtensionPlanEntry>> previousXAREntries, Job job) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            Packager packager = (Packager)this.packagerProvider.get();
            HashSet<DocumentReference> pagesToDelete = new HashSet<DocumentReference>();
            for (Map.Entry<String, Map<XarEntry, XarExtensionPlanEntry>> previousWikiEntry : previousXAREntries.entrySet()) {
                if (previousWikiEntry.getValue().isEmpty()) continue;
                try {
                    List<DocumentReference> references = packager.getDocumentReferences(previousWikiEntry.getValue().keySet(), this.createPackageConfiguration(jobFinishingEvent.getRequest(), previousWikiEntry.getKey()));
                    for (DocumentReference reference : references) {
                        if (!((XarInstalledExtensionRepository)this.xarRepository).getXarInstalledExtensions(reference).isEmpty()) continue;
                        pagesToDelete.add(reference);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
                }
            }
            CleanPagesQuestion question = new CleanPagesQuestion(pagesToDelete);
            Map<DocumentReference, Boolean> pages = question.getPages();
            for (DocumentReference documentReference : pagesToDelete) {
                if (!xarExtensionPlan.containsNewPage(documentReference)) continue;
                pages.remove(documentReference);
            }
            for (Map.Entry entry : pages.entrySet()) {
                XWikiDocument previousDocument;
                XWikiDocument currentDocument;
                DocumentReference reference;
                reference = (DocumentReference)entry.getKey();
                try {
                    currentDocument = xcontext.getWiki().getDocument(reference, xcontext);
                }
                catch (Exception e) {
                    this.logger.error("Failed to get document [{}]", (Object)reference, (Object)e);
                    pages.put(reference, false);
                    continue;
                }
                if (currentDocument.isNew()) {
                    pages.put(reference, false);
                    continue;
                }
                try {
                    previousDocument = xarExtensionPlan.getPreviousXWikiDocument(reference, packager);
                }
                catch (Exception e) {
                    this.logger.error("Failed to get previous version of document [{}]", (Object)reference, (Object)e);
                    pages.put(reference, false);
                    continue;
                }
                try {
                    currentDocument.loadAttachmentsContentSafe(xcontext);
                    if (currentDocument.equalsData(previousDocument)) continue;
                    pages.put(reference, false);
                }
                catch (Exception e) {
                    this.logger.error("Failed to load attachments", (Throwable)e);
                    pages.put(reference, false);
                }
            }
            if (!pages.isEmpty() && jobFinishingEvent.getRequest().isInteractive()) {
                try {
                    job.getStatus().ask((Object)question);
                }
                catch (InterruptedException e) {
                    this.logger.warn("The thread has been interrupted", (Throwable)e);
                    try {
                        xarExtensionPlan.close();
                    }
                    catch (IOException iOException) {
                        this.logger.error("Failed to close XAR extension plan", (Throwable)iOException);
                    }
                    return;
                }
            }
            if (!pages.isEmpty()) {
                this.deletePages(jobFinishingEvent, pages, packager);
            }
        }
        finally {
            try {
                xarExtensionPlan.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close XAR extension plan", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePages(JobFinishingEvent jobFinishingEvent, Map<DocumentReference, Boolean> pages, Packager packager) {
        PackageConfiguration configuration = this.createPackageConfiguration(jobFinishingEvent.getRequest());
        this.observation.notify((Event)new DeletingXarExtensionPages(), (Object)this);
        try {
            for (Map.Entry<DocumentReference, Boolean> entry : pages.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                packager.deleteDocument(entry.getKey(), configuration);
            }
        }
        finally {
            this.observation.notify((Event)new DeletedXarExtensionPages(), (Object)this);
        }
    }

    private void invalidateSecurityCache(Map<String, Map<XarEntry, XarExtensionPlanEntry>> previousXAREntries, Map<XarEntry, XarExtensionPlanEntry> previousRoot, Map<String, Map<XarEntry, LocalExtension>> nextXAREntries, Map<XarEntry, LocalExtension> nextRoot) {
        List<String> wikis;
        try {
            wikis = this.wikiManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logger.error("Failed to get wikis. Security cache won't be properly invalidated.", (Throwable)e);
            wikis = Collections.emptyList();
        }
        for (String wiki : wikis) {
            this.invalidateWikiSecurityCache(wiki, previousXAREntries.get(wiki), previousRoot, nextXAREntries.get(wiki), nextRoot);
        }
    }

    private void invalidateWikiSecurityCache(String wikiId, Map<XarEntry, XarExtensionPlanEntry> previous, Map<XarEntry, XarExtensionPlanEntry> previousRoot, Map<XarEntry, LocalExtension> next, Map<XarEntry, LocalExtension> nextRoot) {
        WikiReference wikiReference = new WikiReference(wikiId);
        if (previous != null) {
            this.invalidateNextSecurityCache(wikiReference, previous, previousRoot, nextRoot);
        }
        if (previousRoot != null) {
            this.invalidateNextSecurityCache(wikiReference, previousRoot, previousRoot, nextRoot);
        }
        if (previous != null) {
            this.invalidatePreviousSecurityCache(wikiReference, previous, next, nextRoot);
        }
        if (previousRoot != null) {
            this.invalidatePreviousSecurityCache(wikiReference, previousRoot, next, nextRoot);
        }
    }

    private void invalidateNextSecurityCache(WikiReference wikiReference, Map<XarEntry, XarExtensionPlanEntry> previous, Map<XarEntry, XarExtensionPlanEntry> previousRoot, Map<XarEntry, LocalExtension> next) {
        if (previous == null) {
            previous = previousRoot;
        }
        for (XarEntry nextXarEntry : next.keySet()) {
            if (previous != null) {
                XarExtensionPlanEntry previousPlanEntry = previous.get(nextXarEntry);
                if (previousPlanEntry == null) {
                    previousPlanEntry = previousRoot.get(nextXarEntry);
                }
                if (previousPlanEntry != null) {
                    XarEntry previousXarEntry = previousPlanEntry.extension.getXarPackage().getEntry((LocalDocumentReference)nextXarEntry);
                    if (previousXarEntry.getType() == nextXarEntry.getType()) continue;
                    this.invalidateSecurityCache((LocalDocumentReference)nextXarEntry, wikiReference);
                    continue;
                }
                this.invalidateSecurityCache((LocalDocumentReference)nextXarEntry, wikiReference);
                continue;
            }
            this.invalidateSecurityCache((LocalDocumentReference)nextXarEntry, wikiReference);
        }
    }

    private void invalidatePreviousSecurityCache(WikiReference wikiReference, Map<XarEntry, XarExtensionPlanEntry> previous, Map<XarEntry, LocalExtension> next, Map<XarEntry, LocalExtension> nextRoot) {
        if (next == null) {
            next = nextRoot;
        }
        for (XarEntry nextXarEntry : previous.keySet()) {
            if (next != null && (next.containsKey(nextXarEntry) || nextRoot.containsKey(nextXarEntry))) continue;
            this.invalidateSecurityCache((LocalDocumentReference)nextXarEntry, wikiReference);
        }
    }

    private void invalidateSecurityCache(LocalDocumentReference documentReference, WikiReference wikiReference) {
        SecurityReference securityReference = this.securityFactory.newEntityReference((EntityReference)new DocumentReference(documentReference, wikiReference));
        this.security.remove(securityReference);
    }

    private PackageConfiguration createPackageConfiguration(Request request) {
        return this.createPackageConfiguration(request, null);
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        PackageConfiguration configuration = new PackageConfiguration();
        configuration.setInteractive(false);
        configuration.setUser(XarExtensionHandler.getRequestUserReference("user.reference", request));
        configuration.setWiki(wiki);
        configuration.setVerbose(request.isVerbose());
        configuration.setSkipMandatorytDocuments(true);
        return configuration;
    }
}

