/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentTreeFilter;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
@Named(value="pristineInstalledExtensionDocument")
public class PristineInstalledExtensionDocumentTreeFilter
extends InstalledExtensionDocumentTreeFilter {
    @Override
    public Set<EntityReference> getChildExclusions(EntityReference parentReference) {
        return this.tree.getChildren(this.getNodeReference(parentReference)).stream().filter(this::hasNoCustomizationsAndContentPages).collect(Collectors.toSet());
    }

    private boolean hasNoCustomizationsAndContentPages(DocumentReference documentReference) {
        return !this.tree.isCustomizedExtensionPage(documentReference) && this.tree.getNestedCustomizedExtensionPages((EntityReference)documentReference).isEmpty() && this.hasNoContentPages(documentReference);
    }

    @Override
    public Set<EntityReference> getDescendantExclusions(EntityReference parentReference) {
        return this.tree.getNestedExtensionPages(this.getNodeReference(parentReference)).stream().filter(extensionPage -> !this.tree.isCustomizedExtensionPage((DocumentReference)extensionPage)).collect(Collectors.toSet());
    }
}

