/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.xar.internal.doc.InstalledExtensionDocumentTree;
import org.xwiki.extension.xar.internal.doc.NestedPageCounter;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.tree.AbstractEntityTreeFilter;

@Component
@Singleton
@Named(value="installedExtensionDocument")
public class InstalledExtensionDocumentTreeFilter
extends AbstractEntityTreeFilter {
    @Inject
    protected InstalledExtensionDocumentTree tree;
    @Inject
    private NestedPageCounter counter;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;

    public Set<EntityReference> getChildExclusions(EntityReference parentReference) {
        return this.tree.getChildren(this.getNodeReference(parentReference)).stream().filter(this::hasNoContentPages).collect(Collectors.toSet());
    }

    protected boolean hasNoContentPages(DocumentReference documentReference) {
        return this.counter.countNestedPages(documentReference) <= (long)this.tree.getNestedExtensionPages((EntityReference)documentReference).size();
    }

    public Set<EntityReference> getDescendantExclusions(EntityReference parentReference) {
        return this.tree.getNestedExtensionPages(this.getNodeReference(parentReference)).stream().collect(Collectors.toSet());
    }

    protected EntityReference getNodeReference(EntityReference entityReference) {
        if (entityReference.getType() == EntityType.SPACE) {
            String defaultDocumentName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
            return new DocumentReference(defaultDocumentName, new SpaceReference(entityReference));
        }
        return entityReference;
    }
}

